/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.ui.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.preferences.ProjectSelectionDialog;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.FormatAllAction;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.tools.base.MethodRef;
import org.junit.tools.generator.utils.GeneratorUtils;
import org.junit.tools.generator.utils.JDTUtils;
import org.junit.tools.messages.Messages;

public class EclipseUIUtils {
    public static Logger logger = Logger.getLogger(EclipseUIUtils.class.getName());

    public static void openInEditor(Shell shell, final IFile file) {
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    if (file != null) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                }
                catch (PartInitException e) {
                    logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        });
    }

    public static void format(IWorkbenchPartSite site, ICompilationUnit ... cus) {
        if (site == null) {
            return;
        }
        FormatAllAction faa = new FormatAllAction((IWorkbenchSite)site);
        faa.runOnMultiple(cus);
    }

    public static void saveAndCloseEditor(String className) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart activeEditor = EclipseUIUtils.getActiveEditor();
        if (activeEditor == null) {
            return;
        }
        String title = activeEditor.getTitle();
        if ((title = title.replace(".java", "")).equals(className = className.replace(".java", ""))) {
            activeEditor.doSave(null);
            page.closeEditor(activeEditor, false);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = EclipseUIUtils.getActiveWorkbenchWindow().getActivePage();
        return page.getActiveEditor();
    }

    public static IEditorInput getEditorInput() {
        IEditorPart activeEditor = EclipseUIUtils.getActiveEditor();
        if (activeEditor != null) {
            return activeEditor.getEditorInput();
        }
        return null;
    }

    public static Object getFirstSelectedElement(ISelection selection) {
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            return treeSelection.getFirstElement();
        }
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            return structuredSelection.getFirstElement();
        }
        if (selection instanceof IFileEditorInput) {
            FileEditorInput editorInput = (FileEditorInput)selection;
            return editorInput.getFile();
        }
        if (selection instanceof TextSelection) {
            return null;
        }
        throw new RuntimeException(Messages.GeneratorUtils_SelectionNotSupported);
    }

    public static void organizeImports(IWorkbenchPartSite site, ICompilationUnit cu) {
        if (cu == null) {
            return;
        }
        if (site == null) {
            return;
        }
        OrganizeImportsAction importAction = new OrganizeImportsAction((IWorkbenchSite)site);
        importAction.setSpecialSelectionProvider(new ISelectionProvider(){
            private ISelection selection;
            private final List<ISelectionChangedListener> listener = new ArrayList<ISelectionChangedListener>();

            public void setSelection(ISelection selection) {
                this.selection = selection;
            }

            public ISelection getSelection() {
                return this.selection;
            }

            public void addSelectionChangedListener(ISelectionChangedListener arg0) {
                this.listener.add(arg0);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener arg0) {
                this.listener.remove(arg0);
            }
        });
        importAction.run(cu);
    }

    public static void selectMethodInEditor(final MethodRef methodRef) {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (methodRef == null) {
                    return;
                }
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                ITextEditor editor = (ITextEditor)page.getActiveEditor();
                ITypeRoot typeRoot = JavaUI.getEditorInputTypeRoot((IEditorInput)editor.getEditorInput());
                ICompilationUnit icu = (ICompilationUnit)typeRoot.getAdapter(ICompilationUnit.class);
                IType type = icu.findPrimaryType();
                IMethod method = null;
                try {
                    method = GeneratorUtils.findMethod(Arrays.asList(type.getMethods()), methodRef);
                }
                catch (JavaModelException javaModelException) {
                    return;
                }
                IMethod element = method;
                JavaUI.revealInEditor((IEditorPart)editor, (IJavaElement)element);
            }
        });
    }

    public static void selectMethodInEditor(final IMethod method) {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                ITextEditor editor = (ITextEditor)page.getActiveEditor();
                IMethod element = method;
                JavaUI.revealInEditor((IEditorPart)editor, (IJavaElement)element);
            }
        });
    }

    public static IJavaProject getJavaProjectFromDialog(Shell shell) {
        Object[] results;
        List<IJavaProject> javaProjects = JDTUtils.getJavaProjects();
        HashSet<IJavaProject> allProjects = new HashSet<IJavaProject>(javaProjects);
        ProjectSelectionDialog dialog = new ProjectSelectionDialog(shell, allProjects);
        if (dialog.open() == 0 && (results = dialog.getResult()).length > 0) {
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                if (result instanceof IJavaProject) {
                    return (IJavaProject)result;
                }
                ++n2;
            }
        }
        return null;
    }

    public static Shell getShell() {
        return EclipseUIUtils.getActiveWorkbenchWindow().getShell();
    }
}

