/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.ui.generator.wizards;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.preferences.ProjectSelectionDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.junit.tools.base.MethodRef;
import org.junit.tools.generator.utils.GeneratorUtils;
import org.junit.tools.generator.utils.JDTUtils;
import org.junit.tools.preferences.JUTPreferences;
import org.junit.tools.ui.generator.swt.control.GroupMethodSelectionCtrl;
import org.junit.tools.ui.generator.wizards.IMethodeSelectionChangedListener;
import org.junit.tools.ui.generator.wizards.pages.MockGeneratorWizardPage;

public class MockGeneratorWizard
extends Wizard
implements INewWizard,
IMethodeSelectionChangedListener {
    private boolean finished = false;
    private MockGeneratorWizardPage mainPage;
    private final IJavaElement classToMock;
    private GroupMethodSelectionCtrl methodSelection;
    private Vector<IMethod> checkedMethods;
    private IJavaProject selectedProject = null;
    private IPackageFragment targetPackage;
    private boolean isMockNew = true;
    private ICompilationUnit mockClass;

    public MockGeneratorWizard(IJavaElement javaElement) {
        this.classToMock = javaElement;
    }

    public void addPages() {
        String title = "Create mock-class";
        this.mainPage = new MockGeneratorWizardPage(title);
        this.mainPage.setTitle(title);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init() throws CoreException {
        IJavaProject project = JDTUtils.getProject(JUTPreferences.getMockProject());
        if (project == null) {
            project = JDTUtils.createProject(JUTPreferences.getMockProject(), this.classToMock.getJavaProject());
        }
        this.methodSelection = new GroupMethodSelectionCtrl();
        this.methodSelection.init(this.mainPage.getView().getMethodSelectionGroup(), this.classToMock);
        this.methodSelection.addListener(this);
        this.methodSelection.deactivateFilters();
        this.isMockNew = true;
        if (project != null) {
            Text txtProject = this.mainPage.getView().getTxtProject();
            txtProject.setText(project.getElementName());
            txtProject.setData((Object)project);
            this.selectedProject = project;
            IPackageFragment pckg = JDTUtils.getPackage(this.classToMock);
            this.targetPackage = JDTUtils.getPackage(project, String.valueOf(pckg.getElementName()) + ".mock", false);
            if (this.targetPackage != null && this.targetPackage.exists()) {
                String mockClassName = this.classToMock.getElementName().replace(".java", "Mock.java");
                if (!(mockClassName = mockClassName.replace(".class", "Mock.java")).endsWith("Mock.java")) {
                    mockClassName = String.valueOf(mockClassName) + "Mock.java";
                }
                this.mockClass = this.targetPackage.getCompilationUnit(mockClassName);
                if (this.mockClass != null && this.mockClass.exists()) {
                    this.isMockNew = false;
                    HashMap<MethodRef, IMethod> existingMethods = GeneratorUtils.getExistingTestMethods(this.mockClass);
                    this.methodSelection.setExistingMethods(existingMethods);
                }
            }
        }
        this.mainPage.getView().getBtnSelectProject().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                MockGeneratorWizard.this.handleContainer();
            }
        });
    }

    public boolean performFinish() {
        this.finished = true;
        return true;
    }

    public void init(IWorkbench arg0, IStructuredSelection arg1) {
    }

    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void methodSelectionChanged(Vector<IMethod> chckdMethods) {
        this.checkedMethods = chckdMethods;
    }

    public Vector<IMethod> getCheckedMethods() {
        return this.checkedMethods;
    }

    private void handleContainer() {
        Object[] results;
        List<IJavaProject> javaProjects = JDTUtils.getJavaProjects();
        HashSet<IJavaProject> setProjects = new HashSet<IJavaProject>(javaProjects);
        ProjectSelectionDialog dialog = new ProjectSelectionDialog(this.getShell(), setProjects);
        if (dialog.open() == 0 && (results = dialog.getResult()).length > 0) {
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                if (result instanceof IJavaProject) {
                    IJavaProject project = (IJavaProject)result;
                    this.mainPage.getView().getTxtProject().setText(project.getElementName());
                    this.mainPage.getView().getTxtProject().setData(result);
                    this.selectedProject = project;
                    return;
                }
                ++n2;
            }
        }
    }

    public IJavaProject getProject() {
        return this.selectedProject;
    }

    public IPackageFragment getTargetPackage() {
        return this.targetPackage;
    }

    public boolean isMockNew() {
        return this.isMockNew;
    }

    public ICompilationUnit getMockClass() {
        return this.mockClass;
    }

    public HashMap<MethodRef, IMethod> getExistingMethods() {
        return this.methodSelection.getExistingMethods();
    }

    @Override
    public void selectedMethodChecked(IMethod selectedMethod) {
    }
}

