/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.ui.generator.wizards;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.junit.tools.base.MethodRef;
import org.junit.tools.generator.IGeneratorConstants;
import org.junit.tools.generator.model.GeneratorModel;
import org.junit.tools.generator.model.tml.Method;
import org.junit.tools.generator.model.tml.Param;
import org.junit.tools.generator.model.tml.Result;
import org.junit.tools.generator.model.tml.Settings;
import org.junit.tools.generator.model.tml.Test;
import org.junit.tools.generator.model.tml.Testprio;
import org.junit.tools.generator.utils.GeneratorUtils;
import org.junit.tools.generator.utils.JDTUtils;
import org.junit.tools.preferences.JUTPreferences;
import org.junit.tools.ui.generator.swt.control.GroupMethodSelectionCtrl;
import org.junit.tools.ui.generator.wizards.GeneratorWizardBase;
import org.junit.tools.ui.generator.wizards.IMethodeSelectionChangedListener;
import org.junit.tools.ui.generator.wizards.pages.GeneratorWizardMainPage;
import org.junit.tools.ui.utils.EclipseUIUtils;

public class GeneratorWizardMain
extends GeneratorWizardBase
implements IGeneratorConstants,
IMethodeSelectionChangedListener {
    private final ICompilationUnit testBase;
    private final ICompilationUnit testClass;
    private GroupMethodSelectionCtrl methodSelection;
    private Vector<IMethod> checkedMethods = new Vector(0);
    private IJavaProject selectedTestProject;

    public GeneratorWizardMain(GeneratorModel model, GeneratorWizardMainPage generatorWizardMainPage) {
        super(model, generatorWizardMainPage);
        this.testBase = this.getModel().getJUTElements().getClassesAndPackages().getBaseClass();
        this.testClass = this.getModel().getJUTElements().getClassesAndPackages().getTestClass();
        this.selectedTestProject = this.getModel().getJUTElements().getProjects().getTestProject();
    }

    @Override
    public GeneratorWizardMainPage getPage() {
        return (GeneratorWizardMainPage)super.getPage();
    }

    private void addListener(GeneratorWizardMainPage page) {
        page.getView().getBtnToggleStandardMethods().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorWizardMain.this.handleToggleStandardMethods();
            }
        });
        page.getView().getBtnToggleOther().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorWizardMain.this.handleToggleOther();
            }
        });
        page.getView().getBtnTestProject().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                GeneratorWizardMain.this.handleTestProject();
            }
        });
        if (page.getView().getBtnSuperClass() != null) {
            page.getView().getBtnSuperClass().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    GeneratorWizardMain.this.handleSuperClass();
                }
            });
        }
        this.methodSelection.addListener(this);
    }

    protected void handleTestProject() {
        IJavaProject project = EclipseUIUtils.getJavaProjectFromDialog(this.getPage().getShell());
        if (project != null) {
            this.getPage().getView().getTxtTestProject().setText(project.getElementName());
            this.getPage().getView().getTxtTestProject().setData((Object)project);
            this.selectedTestProject = project;
        }
    }

    protected void handleSuperClass() {
        Object[] results;
        SelectionDialog dialog;
        try {
            String filter = "";
            Object superClass = this.getPage().getView().getTxtSuperClass().getData();
            if (superClass instanceof IType) {
                filter = ((IType)superClass).getFullyQualifiedName();
            }
            dialog = JavaUI.createTypeDialog((Shell)this.getPage().getShell(), (IRunnableContext)this.getPage().getWizard().getContainer(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false, (String)filter);
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        if (dialog.open() == 0 && (results = dialog.getResult()).length > 0) {
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                if (result instanceof IType) {
                    IType superClass = (IType)result;
                    this.getPage().getView().getTxtSuperClass().setText(superClass.getFullyQualifiedName());
                    this.getPage().getView().getTxtSuperClass().setData((Object)superClass);
                    return;
                }
                ++n2;
            }
        }
    }

    protected void handleToggleOther() {
        this.toggleButton(this.getPage().getView().getBtnTestsuites());
        this.toggleButton(this.getPage().getView().getBtnLogger());
        this.toggleButton(this.getPage().getView().getBtnFailassertion());
    }

    protected void handleToggleStandardMethods() {
        this.toggleButton(this.getPage().getView().getBtnSetup());
        this.toggleButton(this.getPage().getView().getBtnSetupbeforeclass());
        this.toggleButton(this.getPage().getView().getBtnTeardown());
        this.toggleButton(this.getPage().getView().getBtnTeardownafterclass());
    }

    private void toggleButton(Button btn) {
        boolean selection = !btn.getSelection();
        btn.setSelection(selection);
    }

    @Override
    public void methodSelectionChanged(Vector<IMethod> chkdMethods) {
        this.checkedMethods = chkdMethods;
        if (this.checkedMethods.size() == 0) {
            this.getPage().updateStatus("Select at least one method!");
            return;
        }
        this.getPage().getView().getCheckboxTreeViewer().expandAll();
        this.getPage().updateStatus(null);
    }

    @Override
    public void selectedMethodChecked(IMethod selectedMethod) {
        String description = this.getPage().getDescription();
        if (description == null) {
            description = "";
        }
        if (!"".equals(description.trim())) {
            description = String.valueOf(description) + "\n";
        }
        description = String.valueOf(description) + "Method " + selectedMethod.getElementName() + " automatically checked!";
        this.getPage().setDescription(description);
    }

    public Vector<IMethod> getCheckedMethods() {
        return this.checkedMethods;
    }

    @Override
    public void initPage() {
        GeneratorWizardMainPage page = this.getPage();
        Test tmlTest = this.getModel().getTmlTest();
        List<Method> tmlMethods = null;
        this.initDefaults(page);
        if (tmlTest != null) {
            tmlMethods = tmlTest.getMethod();
            this.initPageSettings(page, tmlTest.getSettings());
            this.initTestprio(page, tmlTest);
        }
        this.methodSelection = new GroupMethodSelectionCtrl();
        this.addListener(page);
        try {
            boolean writeTML = JUTPreferences.isWriteTML();
            if (writeTML) {
                this.methodSelection.init(page.getView().getMethodSelectionGroup(), (IJavaElement)this.testBase, tmlMethods, this.getModel());
            } else {
                this.methodSelection.init(page.getView().getMethodSelectionGroup(), (IJavaElement)this.testBase, this.testClass, this.getModel());
            }
            this.methodSelectionChanged(this.methodSelection.getCheckedMethods());
            this.methodSelection.deactivateFilters();
        }
        catch (JavaModelException javaModelException) {}
    }

    private void initDefaults(GeneratorWizardMainPage page) {
        String testProjectPostfix = JUTPreferences.getTestProjectPostfix();
        String baseProjectName = this.getModel().getJUTElements().getProjects().getBaseProject().getElementName();
        String testProjectName = String.valueOf(baseProjectName) + testProjectPostfix;
        page.getView().getTxtTestProject().setText(testProjectName);
        if (page.getView().getTxtSuperClass() != null) {
            page.getView().getTxtSuperClass().setText(JUTPreferences.getTestClassSuperType());
        }
        page.getView().getMethodPrefix().setText(JUTPreferences.getTestMethodPrefix());
        page.getView().getBtnTestsuites().setSelection(true);
    }

    private void initPageSettings(GeneratorWizardMainPage page, Settings settings) {
        if (settings == null) {
            return;
        }
        page.getView().getBtnSetup().setSelection(settings.isSetUp());
        page.getView().getBtnSetupbeforeclass().setSelection(settings.isSetUpBeforeClass());
        page.getView().getBtnTeardown().setSelection(settings.isTearDown());
        page.getView().getBtnTeardownafterclass().setSelection(settings.isTearDownBeforeClass());
        page.getView().getBtnTestsuites().setSelection(settings.isTestsuites());
        page.getView().getBtnFailassertion().setSelection(settings.isFailAssertions());
        page.getView().getBtnLogger().setSelection(settings.isLogger());
    }

    private void initTestprio(GeneratorWizardMainPage page, Test tmlTest) {
        page.getView().getBtnPrioHigh().setSelection(false);
        page.getView().getBtnPrioStandard().setSelection(false);
        page.getView().getBtnPrioLow().setSelection(false);
        Testprio testprio = tmlTest.getTestPrio();
        if (testprio != null) {
            switch (testprio) {
                case HIGH: {
                    page.getView().getBtnPrioHigh().setSelection(true);
                    break;
                }
                case DEFAULT: {
                    page.getView().getBtnPrioStandard().setSelection(true);
                    break;
                }
                case LOW: {
                    page.getView().getBtnPrioLow().setSelection(true);
                    break;
                }
                default: {
                    page.getView().getBtnPrioStandard().setSelection(true);
                    break;
                }
            }
        } else {
            page.getView().getBtnPrioStandard().setSelection(true);
        }
    }

    @Override
    public void updateModel() {
        Test tmlTest = this.getModel().getTmlTest();
        GeneratorWizardMainPage page = this.getPage();
        if (tmlTest == null) {
            tmlTest = this.getObjectFactory().createTest();
            this.getModel().setTmlTest(tmlTest);
        }
        tmlTest.setTestBase(this.testBase.getPath().toString());
        if (this.testClass != null) {
            tmlTest.setTestClass(this.testClass.getPath().toString());
        }
        tmlTest.setVersion("1.0.0");
        if (page.getView().getBtnPrioHigh().getSelection()) {
            tmlTest.setTestPrio(Testprio.HIGH);
        } else if (page.getView().getBtnPrioStandard().getSelection()) {
            tmlTest.setTestPrio(Testprio.DEFAULT);
        } else if (page.getView().getBtnPrioLow().getSelection()) {
            tmlTest.setTestPrio(Testprio.LOW);
        }
        Text txtSuperClass = page.getView().getTxtSuperClass();
        if (txtSuperClass != null) {
            Object data = txtSuperClass.getData();
            if (data != null && data instanceof IType) {
                tmlTest.setSuperClassPackage(((IType)data).getPackageFragment().getElementName());
                tmlTest.setSuperClass(((IType)data).getElementName());
            } else {
                tmlTest.setSuperClass(txtSuperClass.getText());
            }
        }
        this.updateModelSettings(page, tmlTest);
        try {
            this.updateModelMethods(tmlTest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateModelSettings(GeneratorWizardMainPage page, Test tmlTest) {
        Settings settings = tmlTest.getSettings();
        if (settings == null) {
            settings = this.getObjectFactory().createSettings();
            tmlTest.setSettings(settings);
        }
        settings.setSetUp(page.getView().getBtnSetup().getSelection());
        settings.setSetUpBeforeClass(page.getView().getBtnSetupbeforeclass().getSelection());
        settings.setTearDown(page.getView().getBtnTeardown().getSelection());
        settings.setTearDownBeforeClass(page.getView().getBtnTeardownafterclass().getSelection());
        settings.setTestsuites(page.getView().getBtnTestsuites().getSelection());
        settings.setLogger(page.getView().getBtnLogger().getSelection());
        settings.setFailAssertions(page.getView().getBtnFailassertion().getSelection());
    }

    private void updateModelMethods(Test tmlTest) throws JavaModelException {
        tmlTest.getMethod().clear();
        HashMap<IMethod, Method> methodMap = new HashMap<IMethod, Method>();
        this.getModel().setMethodMap(methodMap);
        for (IMethod method : this.methodSelection.getCheckedMethods()) {
            Method tmlMethod = this.getObjectFactory().createMethod();
            tmlTest.getMethod().add(tmlMethod);
            this.updateModelMethod(method, tmlMethod);
            methodMap.put(method, tmlMethod);
        }
        HashMap<MethodRef, IMethod> existingMethods = this.methodSelection.getExistingMethods();
        this.getModel().setExistingMethods(existingMethods);
        this.getModel().setMethodsToCreate(GeneratorUtils.getMethodsToCreate(existingMethods, this.checkedMethods));
        this.getModel().setMethodsToDelete(GeneratorUtils.getMethodsToDelete(existingMethods, this.checkedMethods));
    }

    public void updateModelMethod(IMethod method, Method tmlMethod) throws JavaModelException {
        ILocalVariable[] parameters;
        tmlMethod.setName(method.getElementName());
        tmlMethod.setModifier(JDTUtils.getMethodModifier(method));
        tmlMethod.setStatic(JDTUtils.isStatic(method));
        tmlMethod.setSignature(method.getSignature());
        ILocalVariable[] iLocalVariableArray = parameters = method.getParameters();
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalVariable parameter = iLocalVariableArray[n2];
            Param param = this.getObjectFactory().createParam();
            param.setName(parameter.getElementName());
            param.setType(Signature.getSignatureSimpleName((String)parameter.getTypeSignature()));
            tmlMethod.getParam().add(param);
            ++n2;
        }
        String returnType = method.getReturnType();
        if (returnType != null && !returnType.equals("V")) {
            Result result = this.getObjectFactory().createResult();
            result.setName("result");
            result.setType(Signature.getSignatureSimpleName((String)returnType));
            tmlMethod.setResult(result);
        }
    }

    public IJavaProject getSelectedProject() {
        return this.selectedTestProject;
    }
}

