/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.ui.generator.swt.control;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.junit.tools.base.MethodRef;
import org.junit.tools.generator.IGeneratorConstants;
import org.junit.tools.generator.model.GeneratorModel;
import org.junit.tools.generator.model.JUTElements;
import org.junit.tools.generator.model.tml.Method;
import org.junit.tools.generator.utils.GeneratorUtils;
import org.junit.tools.generator.utils.JDTUtils;
import org.junit.tools.preferences.JUTPreferences;
import org.junit.tools.ui.generator.swt.view.GroupMethodSelectionView;
import org.junit.tools.ui.generator.wizards.IMethodeSelectionChangedListener;

public class GroupMethodSelectionCtrl
implements IGeneratorConstants {
    private final Logger logger = Logger.getLogger(GroupMethodSelectionCtrl.class.getName());
    private ViewerFilterMethods viewerFilterMethods;
    private final Vector<IMethod> checkedMethods = new Vector();
    private GroupMethodSelectionView group;
    private final Vector<IMethodeSelectionChangedListener> listeners = new Vector();
    private final Vector<String> nameFilterStartsWith = new Vector();
    private final Vector<String> nameFilterEquals = new Vector();
    private final Vector<String> nameFilterEndsWith = new Vector();
    private boolean modifierFilterSelected = true;
    private boolean nameFilterSelected = true;
    private boolean existingMethodsFilterSelected = true;
    private Vector<IMethod> baseClassMethods = null;
    private GeneratorModel model;
    private IJavaElement treeClass;
    private HashMap<MethodRef, IMethod> existingMethods;

    private void addInternalListener(GroupMethodSelectionView grp) {
        grp.getBtnSelectAll().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    GroupMethodSelectionCtrl.this.handleSelectAll();
                }
                catch (JavaModelException e1) {
                    GroupMethodSelectionCtrl.this.logger.log(Level.SEVERE, e1.getMessage());
                }
            }
        });
        grp.getBtnDeselectAll().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    GroupMethodSelectionCtrl.this.handleDeselectAll();
                }
                catch (JavaModelException e1) {
                    GroupMethodSelectionCtrl.this.logger.log(Level.SEVERE, e1.getMessage());
                }
            }
        });
        grp.getBtnNamefilter().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupMethodSelectionCtrl.this.handleNameFilterSelection();
            }
        });
        grp.getBtnModifierfilter().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupMethodSelectionCtrl.this.handleModifierFilterSelection();
            }
        });
        grp.getBtnExistingMethodsFilter().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupMethodSelectionCtrl.this.handleExistingMethodsFilterSelection();
            }
        });
        grp.getCheckboxTreeViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                try {
                    if (element instanceof IMethod) {
                        this.handleMethodSelection(event.getChecked(), (IMethod)element);
                    } else if (element instanceof IType) {
                        if (event.getChecked()) {
                            GroupMethodSelectionCtrl.this.handleSelectAll();
                        } else {
                            GroupMethodSelectionCtrl.this.handleDeselectAll();
                        }
                    }
                }
                catch (JavaModelException javaModelException) {}
                GroupMethodSelectionCtrl.this.methodSelectionChanged();
            }

            private void handleMethodSelection(boolean checked, IMethod element) throws JavaModelException {
                if (element.isConstructor()) {
                    return;
                }
                if (checked) {
                    if (!GroupMethodSelectionCtrl.this.checkedMethods.contains(element)) {
                        GroupMethodSelectionCtrl.this.checkedMethods.add(element);
                    }
                } else {
                    GroupMethodSelectionCtrl.this.checkedMethods.remove(element);
                }
            }
        });
    }

    public void deactivateFilters() {
        this.group.getBtnExistingMethodsFilter().setSelection(false);
        this.group.getBtnModifierfilter().setSelection(false);
        this.group.getBtnNamefilter().setSelection(false);
        this.handleExistingMethodsFilterSelection();
        this.handleModifierFilterSelection();
        this.handleNameFilterSelection();
    }

    public void init(GroupMethodSelectionView grp, IJavaElement javaElement, List<Method> tmlMethods, GeneratorModel utmModel) throws JavaModelException {
        this.viewerFilterMethods = new ViewerFilterMethods(tmlMethods);
        this.initReal(grp, javaElement, utmModel);
    }

    public void init(GroupMethodSelectionView grp, IJavaElement javaElement, ICompilationUnit testClass, GeneratorModel utmModel) throws JavaModelException {
        this.initReal(grp, javaElement, utmModel);
    }

    public void init(GroupMethodSelectionView grp, IJavaElement javaElement) throws JavaModelException {
        this.initReal(grp, javaElement, null);
    }

    private void initReal(GroupMethodSelectionView grp, IJavaElement javaElement, GeneratorModel utmModel) throws JavaModelException {
        this.group = grp;
        this.model = utmModel;
        this.treeClass = javaElement;
        if (this.viewerFilterMethods == null) {
            this.viewerFilterMethods = new ViewerFilterMethods(null);
            this.group.getCheckboxTreeViewer().addFilter((ViewerFilter)this.viewerFilterMethods);
        }
        this.group.getCheckboxTreeViewer().setCheckStateProvider((ICheckStateProvider)new CheckStateProvider());
        this.group.getCheckboxTreeViewer().setInput((Object)javaElement);
        this.group.getCheckboxTreeViewer().expandAll();
        this.group.getCheckboxTreeViewer().setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IMethod && e2 instanceof IMethod) {
                    IMethod m1 = (IMethod)e1;
                    IMethod m2 = (IMethod)e2;
                    return m1.getElementName().compareTo(m2.getElementName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.initNameFilters();
        this.initCheckedMethods();
        this.group.getCheckboxTreeViewer().refresh();
        this.addInternalListener(grp);
    }

    private void selectAll(boolean state) {
        Object[] objects;
        CheckboxTreeViewer checkboxTreeViewer = this.getGroup().getCheckboxTreeViewer();
        ITreeContentProvider contentProvider = (ITreeContentProvider)checkboxTreeViewer.getContentProvider();
        Object[] objectArray = objects = contentProvider.getElements(checkboxTreeViewer.getInput());
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            checkboxTreeViewer.setChecked(object, state);
            ++n2;
        }
        for (IMethod method : this.getBaseClassMethods()) {
            if (!this.viewerFilterMethods.select(null, method.getParent(), method)) continue;
            if (state) {
                this.checkedMethods.add(method);
                continue;
            }
            this.checkedMethods.remove(method);
        }
    }

    private void handleSelectAll() throws JavaModelException {
        this.selectAll(true);
        this.methodSelectionChanged();
    }

    private void methodSelectionChanged() {
        for (IMethodeSelectionChangedListener listener : this.listeners) {
            listener.methodSelectionChanged(this.getCheckedMethods());
        }
    }

    private void selectedMethodChecked(IMethod method) {
        for (IMethodeSelectionChangedListener listener : this.listeners) {
            listener.selectedMethodChecked(method);
        }
    }

    private void handleDeselectAll() throws JavaModelException {
        this.selectAll(false);
        this.methodSelectionChanged();
    }

    private void handleNameFilterSelection() {
        this.nameFilterSelected = this.getGroup().getBtnNamefilter().getSelection();
        this.getGroup().getCheckboxTreeViewer().refresh();
        this.methodSelectionChanged();
    }

    private void handleModifierFilterSelection() {
        this.modifierFilterSelected = this.getGroup().getBtnModifierfilter().getSelection();
        this.getGroup().getCheckboxTreeViewer().refresh();
        this.methodSelectionChanged();
    }

    private void handleExistingMethodsFilterSelection() {
        this.existingMethodsFilterSelected = this.getGroup().getBtnExistingMethodsFilter().getSelection();
        this.getGroup().getCheckboxTreeViewer().refresh();
        this.methodSelectionChanged();
    }

    public Vector<IMethod> getCheckedMethods() {
        return this.checkedMethods;
    }

    protected boolean isNameFilterSelected() {
        return this.nameFilterSelected;
    }

    protected boolean isModifierFilterSelected() {
        return this.modifierFilterSelected;
    }

    protected boolean isExistingMethodsFilterSelected() {
        return this.existingMethodsFilterSelected;
    }

    private GroupMethodSelectionView getGroup() {
        return this.group;
    }

    protected boolean containMethod(IMethod method, List<Method> tmlMethods) {
        HashMap<IMethod, Method> methodMap = this.getModel().getMethodMap();
        if (methodMap.containsKey(method)) {
            return methodMap.get(method) != null;
        }
        Method tmlMethod = GeneratorUtils.getClosestMethod(method, tmlMethods);
        if (tmlMethod != null) {
            methodMap.put(method, tmlMethod);
            return true;
        }
        methodMap.put(method, null);
        return false;
    }

    private void initCheckedMethods() throws JavaModelException {
        if (this.getModel() != null && this.getModel().getTmlTest() != null) {
            for (IMethod baseClassMethod : this.getBaseClassMethods()) {
                if (!this.containMethod(baseClassMethod, this.getModel().getTmlTest().getMethod())) continue;
                this.checkedMethods.add(baseClassMethod);
            }
            return;
        }
        if (this.existingMethods == null && this.getModel() != null) {
            JUTElements.JUTConstructorsAndMethods constructorsAndMethods;
            IMethod selectedMethod;
            JUTElements utmElements = this.getModel().getJUTElements();
            ICompilationUnit baseClass = utmElements.getClassesAndPackages().getBaseClass();
            ICompilationUnit testClass = utmElements.getClassesAndPackages().getTestClass();
            this.existingMethods = GeneratorUtils.getExistingTestMethods(baseClass, testClass, true);
            if (utmElements.getProjects().isBaseProjectSelected() && (selectedMethod = (constructorsAndMethods = utmElements.getConstructorsAndMethods()).getSelectedMethod()) != null) {
                this.checkedMethods.add(selectedMethod);
                this.selectedMethodChecked(selectedMethod);
            }
        }
        if (this.existingMethods != null && this.existingMethods.size() > 0) {
            try {
                List<IMethod> methods = JDTUtils.getMethods(this.treeClass, false);
                for (IMethod method : methods) {
                    boolean nameMatched = false;
                    for (MethodRef methodRef : this.existingMethods.keySet()) {
                        String signatureToCompare = methodRef.isSignatureChanged() ? methodRef.getSignatureNew() : methodRef.getSignature();
                        if (!methodRef.getName().equals(method.getElementName())) continue;
                        if (signatureToCompare.equals(method.getSignature())) {
                            this.checkedMethods.add(method);
                            break;
                        }
                        nameMatched = true;
                    }
                    if (!nameMatched || !JDTUtils.isMethodNameUnique(method)) continue;
                    this.checkedMethods.add(method);
                }
            }
            catch (JavaModelException e) {
                this.logger.warning(e.getMessage());
            }
        }
    }

    private Vector<IMethod> getBaseClassMethods() {
        if (this.getModel() == null) {
            try {
                return new Vector<IMethod>(JDTUtils.getMethods(this.treeClass, false));
            }
            catch (JavaModelException e) {
                this.logger.log(Level.SEVERE, e.getMessage());
                return new Vector<IMethod>(0);
            }
        }
        if (this.baseClassMethods == null) {
            this.baseClassMethods = this.getModel().getJUTElements().getConstructorsAndMethods().getBaseClassMethods();
        }
        return this.baseClassMethods;
    }

    private void initNameFilters() {
        String[] stringArray = JUTPreferences.getTestMethodFilterName();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (filter.startsWith("*")) {
                this.nameFilterEndsWith.add(filter.replaceFirst("*", ""));
            } else if (filter.endsWith("*")) {
                this.nameFilterStartsWith.add(filter.replace("*", ""));
            } else {
                this.nameFilterEquals.add(filter);
            }
            ++n2;
        }
    }

    private boolean isMethodNameAllowed(IMethod method) {
        String methodName = method.getElementName().replace(".java", "");
        Vector<String> startsWithFilter = this.getTestClassNameFilterStartsWith();
        Vector<String> equalsFilter = this.getTestClassNameFilterEquals();
        Vector<String> endsFilter = this.getTestClassNameFilterEndsWith();
        for (String filter : startsWithFilter) {
            if (!methodName.startsWith(filter)) continue;
            return false;
        }
        for (String filter : equalsFilter) {
            if (!methodName.equalsIgnoreCase(filter)) continue;
            return false;
        }
        for (String filter : endsFilter) {
            if (!methodName.endsWith(filter)) continue;
            return false;
        }
        return true;
    }

    private boolean isMethodAllowed(IMethod method, boolean nameFilter, boolean modifierFilter) throws JavaModelException {
        if (modifierFilter && !this.isModifierAllowed(method)) {
            return false;
        }
        return !nameFilter || this.isMethodNameAllowed(method);
    }

    private Vector<String> getTestClassNameFilterStartsWith() {
        return this.nameFilterStartsWith;
    }

    private Vector<String> getTestClassNameFilterEquals() {
        return this.nameFilterEquals;
    }

    private Vector<String> getTestClassNameFilterEndsWith() {
        return this.nameFilterEndsWith;
    }

    protected GeneratorModel getModel() {
        return this.model;
    }

    private boolean isModifierAllowed(IMethod method) throws JavaModelException {
        String modifier = JDTUtils.getMethodModifier(method);
        String[] stringArray = JUTPreferences.getTestMethodFilterModifier();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String notAllowedModifier = stringArray[n2];
            if ("public".equals(modifier) ? "public".equalsIgnoreCase(notAllowedModifier) : ("protected".equals(modifier) ? "protected".equalsIgnoreCase(notAllowedModifier) : ("private".equals(modifier) ? "private".equalsIgnoreCase(notAllowedModifier) : "".equals(modifier) && "".equalsIgnoreCase(notAllowedModifier)))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void addListener(IMethodeSelectionChangedListener methodSelectionChangedListener) {
        this.listeners.add(methodSelectionChangedListener);
    }

    public void removeListener(IMethodeSelectionChangedListener methodSelectionChangedListener) {
        this.listeners.remove(methodSelectionChangedListener);
    }

    public void setExistingMethods(HashMap<MethodRef, IMethod> existingMethods) throws JavaModelException {
        this.existingMethods = existingMethods;
        this.initCheckedMethods();
        this.handleExistingMethodsFilterSelection();
    }

    public HashMap<MethodRef, IMethod> getExistingMethods() {
        return this.existingMethods;
    }

    class CheckStateProvider
    implements ICheckStateProvider {
        CheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            IJavaElement javaElement;
            if (GroupMethodSelectionCtrl.this.getCheckedMethods().contains(element)) {
                return true;
            }
            return element instanceof IJavaElement && this.isParentChecked((javaElement = (IJavaElement)element).getParent());
        }

        private boolean isParentChecked(IJavaElement element) {
            if (element == null) {
                return false;
            }
            if (element instanceof IMethod && GroupMethodSelectionCtrl.this.getCheckedMethods().contains(element)) {
                return true;
            }
            return this.isParentChecked(element.getParent());
        }

        public boolean isGrayed(Object element) {
            return GroupMethodSelectionCtrl.this.getGroup().getCheckboxTreeViewer().getGrayed(element);
        }
    }

    private class ViewerFilterMethods
    extends ViewerFilter {
        private final List<Method> tmlMethods;

        public ViewerFilterMethods(List<Method> tmlMethods) {
            this.tmlMethods = tmlMethods;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IMethod) {
                IMethod method;
                block7: {
                    block8: {
                        block6: {
                            method = (IMethod)element;
                            try {
                                if (!method.isConstructor()) break block6;
                                return false;
                            }
                            catch (JavaModelException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if (!GroupMethodSelectionCtrl.this.isExistingMethodsFilterSelected()) break block7;
                        if (!JUTPreferences.isWriteTML() || this.tmlMethods == null || !GroupMethodSelectionCtrl.this.containMethod(method, this.tmlMethods)) break block8;
                        return false;
                    }
                    if (GroupMethodSelectionCtrl.this.existingMethods == null || GroupMethodSelectionCtrl.this.existingMethods.size() <= 0 || GeneratorUtils.findMethod(GroupMethodSelectionCtrl.this.existingMethods.keySet(), method) == null) break block7;
                    return false;
                }
                return GroupMethodSelectionCtrl.this.isMethodAllowed(method, GroupMethodSelectionCtrl.this.isNameFilterSelected(), GroupMethodSelectionCtrl.this.isModifierFilterSelected());
            }
            return element instanceof IType && !(parentElement instanceof IType);
        }
    }
}

