/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.reports;

import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.sql.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.junit.tools.base.JUTException;
import org.junit.tools.base.JUTWarning;
import org.junit.tools.base.MethodAnalyzer;
import org.junit.tools.generator.model.JUTElements;
import org.junit.tools.generator.model.tml.Testprio;
import org.junit.tools.generator.utils.GeneratorUtils;
import org.junit.tools.generator.utils.JDTUtils;
import org.junit.tools.reports.model.NewMethods;
import org.junit.tools.reports.model.ObjectFactory;
import org.junit.tools.reports.model.RepClass;
import org.junit.tools.reports.model.RepMethod;
import org.junit.tools.reports.model.RepPackage;
import org.junit.tools.reports.model.RepProject;
import org.junit.tools.reports.model.Report;
import org.junit.tools.reports.model.Statistics;

public class ReportCreator {
    private final ObjectFactory of = new ObjectFactory();
    private String todayDate = "";

    public void createNecessaryTestclassesReport(JUTElements elements, IProgressMonitor monitor) throws JUTWarning, JavaModelException, JUTException {
        IJavaProject baseProject = elements.getProjects().getBaseProject();
        IJavaProject testProject = elements.getProjects().getTestProject();
        RepProject oldReport = null;
        try {
            oldReport = this.readReport(testProject);
        }
        catch (Exception e) {
            throw new JUTException(e);
        }
        int necessaryTestClassesCounter = 0;
        int necessaryTestMethodsCounter = 0;
        int availableTestClassesCounter = 0;
        int availableTestMethodsCounter = 0;
        int newMethodsCounter = 0;
        MethodAnalyzer ma = new MethodAnalyzer();
        if (testProject != null && testProject.exists()) {
            monitor.beginTask("create report", 15);
            int monitorCounter = 0;
            RepProject repProject = this.of.createRepProject();
            repProject.setId(baseProject.getElementName());
            JUTElements utmElementsFromBase = JUTElements.initJUTElements(baseProject);
            IPackageFragment[] iPackageFragmentArray = baseProject.getPackageFragments();
            int n = iPackageFragmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment pf = iPackageFragmentArray[n2];
                RepPackage repPackage = null;
                RepPackage oldRepPackage = null;
                ICompilationUnit[] iCompilationUnitArray = pf.getCompilationUnits();
                int n3 = iCompilationUnitArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICompilationUnit baseCu = iCompilationUnitArray[n4];
                    if (++monitorCounter > 10) {
                        monitorCounter = 0;
                        if (this.incrementTask(monitor, 1)) {
                            return;
                        }
                    }
                    Map<IMethod, MethodAnalyzer.MethodAnalyzeResult> analyzedMethods = ma.analyzeAllMethods(baseCu);
                    boolean testClassNecessary = false;
                    boolean testClassAvailable = false;
                    if (analyzedMethods.size() > 0) {
                        RepClass repClass = null;
                        RepClass oldRepClass = null;
                        ICompilationUnit testCu = null;
                        try {
                            utmElementsFromBase.initClassesAndPackages(baseCu);
                            testCu = utmElementsFromBase.getClassesAndPackages().getTestClass();
                            if (testCu != null && testCu.exists()) {
                                testClassAvailable = true;
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        for (Map.Entry<IMethod, MethodAnalyzer.MethodAnalyzeResult> analyzedMethodEntry : analyzedMethods.entrySet()) {
                            Report report;
                            boolean isTestMethodAvailable = false;
                            IMethod method = analyzedMethodEntry.getKey();
                            MethodAnalyzer.MethodAnalyzeResult mar = analyzedMethodEntry.getValue();
                            String subtype = "";
                            if (mar.getNumberOfIfStatements() < 2 && mar.isOnlyNullChecks() && mar.getTestPrio() == Testprio.LOW) continue;
                            ++necessaryTestMethodsCounter;
                            if (testCu != null && testCu.exists()) {
                                IMethod[] iMethodArray = testCu.findPrimaryType().getMethods();
                                int n5 = iMethodArray.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    IMethod testMethod = iMethodArray[n6];
                                    if (GeneratorUtils.checkMethodReferenceAndName(method.getElementName(), method.getSignature(), GeneratorUtils.createTestMethodName(method.getElementName()), testMethod)) {
                                        isTestMethodAvailable = true;
                                        break;
                                    }
                                    ++n6;
                                }
                            }
                            if (isTestMethodAvailable) {
                                testClassNecessary = true;
                                ++availableTestMethodsCounter;
                                continue;
                            }
                            if (repPackage == null) {
                                repPackage = this.of.createRepPackage();
                                repPackage.setId(pf.getElementName());
                                repProject.getPackages().add(repPackage);
                                oldRepPackage = this.getPackageFromOldReport(oldReport, pf.getElementName());
                            }
                            if (repClass == null) {
                                repClass = this.of.createRepClass();
                                repClass.setId(baseCu.getElementName());
                                repPackage.getClasses().add(repClass);
                                oldRepClass = this.getClassFromOldReport(oldRepPackage, baseCu.getElementName());
                            }
                            RepMethod repMethod = this.of.createRepMethod();
                            repMethod.setId(method.getElementName());
                            repMethod.setSignature(method.getSignature());
                            repClass.getMethods().add(repMethod);
                            RepMethod oldRepMethod = this.getMethodFromOldReport(oldRepClass, method);
                            if (oldRepMethod != null) {
                                report = oldRepMethod.getReport();
                                repMethod.setReport(report);
                                report.setIsNew(false);
                                if (report.isIsTestAvailable()) {
                                    testClassNecessary = true;
                                    ++availableTestMethodsCounter;
                                } else if (!report.isIsTestNecessary() || report.getCoveredWith() != null && !"".equals(report.getCoveredWith().trim())) {
                                    --necessaryTestMethodsCounter;
                                    if (report.getNumberOfIfStatements() > 0 && mar.getNumberOfIfStatements() > report.getNumberOfIfStatements()) {
                                        report.setCheckAgain(true);
                                    }
                                } else {
                                    testClassNecessary = true;
                                }
                            } else {
                                report = this.createReportEntry(elements, analyzedMethodEntry);
                                repMethod.setReport(report);
                                IJavaElement type = analyzedMethodEntry.getKey().getParent();
                                if (!type.getElementName().equals(baseCu.getPrimaryElement().getElementName().replace(".java", ""))) {
                                    subtype = type.getElementName();
                                    repMethod.setSubtype(subtype);
                                }
                                this.addNewMethodEntry(repProject, repPackage, repClass, repMethod, analyzedMethodEntry, subtype);
                                testClassNecessary = true;
                                ++newMethodsCounter;
                            }
                            report.setNumberOfIfStatements(mar.getNumberOfIfStatements());
                            report.setOnlyNullchecks(mar.isOnlyNullChecks());
                        }
                    }
                    if (testClassNecessary) {
                        ++necessaryTestClassesCounter;
                        if (testClassAvailable) {
                            ++availableTestClassesCounter;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            this.addStatisticsEntry(repProject, availableTestClassesCounter, availableTestMethodsCounter, necessaryTestClassesCounter, necessaryTestMethodsCounter, newMethodsCounter);
            try {
                this.writeReport(testProject, repProject);
            }
            catch (Exception e) {
                new JUTException(e);
            }
        }
    }

    private void addStatisticsEntry(RepProject repProject, int availableTestClassesCounter, int availableTestMethodsCounter, int necessaryTestClassesCounter, int necessaryTestMethodsCounter, int newMethodsCounter) {
        Statistics statistics = this.of.createStatistics();
        statistics.setAvailableTestClassesCounter(availableTestClassesCounter);
        statistics.setAvailableTestMethodsCounter(availableTestMethodsCounter);
        statistics.setNecessaryTestClassesCounter(necessaryTestClassesCounter);
        statistics.setNecessaryTestMethodsCounter(necessaryTestMethodsCounter);
        statistics.setNewMethodsCounter(newMethodsCounter);
        double classCoverage = 0.0;
        double methodCoverage = 0.0;
        classCoverage = necessaryTestClassesCounter == 0 ? 100.0 : (availableTestClassesCounter == 0 ? 0.0 : (double)(availableTestClassesCounter * 100 / necessaryTestClassesCounter));
        methodCoverage = necessaryTestMethodsCounter == 0 ? 100.0 : (availableTestMethodsCounter == 0 ? 0.0 : (double)(availableTestMethodsCounter * 100 / necessaryTestMethodsCounter));
        statistics.setClassCoverage(classCoverage);
        statistics.setMethodCoverage(methodCoverage);
        repProject.setStatistics(statistics);
    }

    private void addNewMethodEntry(RepProject repProject, RepPackage repPackage, RepClass repClass, RepMethod repMethod, Map.Entry<IMethod, MethodAnalyzer.MethodAnalyzeResult> methodEntry, String subtype) throws JavaModelException {
        NewMethods nm = this.getNewMethodsList(repProject, methodEntry);
        if (subtype == null) {
            subtype = "";
        }
        if (!"".equals(subtype)) {
            subtype = String.valueOf(subtype) + ".";
        }
        nm.getFullQualifiedName().add(String.valueOf(repPackage.getId()) + "." + repClass.getId().replace(".java", "") + "." + subtype + repMethod.getId() + "(" + JDTUtils.createParamList(methodEntry.getKey()) + ")");
    }

    private NewMethods getNewMethodsList(RepProject repProject, Map.Entry<IMethod, MethodAnalyzer.MethodAnalyzeResult> methodEntry) {
        NewMethods nm2;
        List<NewMethods> newMethods = repProject.getNewMethods();
        for (NewMethods nm2 : newMethods) {
            if (!nm2.getTestprio().equals(methodEntry.getValue().getTestPrio().value())) continue;
            return nm2;
        }
        nm2 = this.of.createNewMethods();
        nm2.setTestprio(methodEntry.getValue().getTestPrio().value());
        repProject.getNewMethods().add(nm2);
        return nm2;
    }

    private RepClass getClassFromOldReport(RepPackage repPackage, String className) {
        if (repPackage == null) {
            return null;
        }
        for (RepClass repClass : repPackage.getClasses()) {
            if (!repClass.getId().equals(className)) continue;
            return repClass;
        }
        return null;
    }

    private RepPackage getPackageFromOldReport(RepProject oldReport, String packageName) {
        if (oldReport == null) {
            return null;
        }
        for (RepPackage repPackage : oldReport.getPackages()) {
            if (!repPackage.getId().equals(packageName)) continue;
            return repPackage;
        }
        return null;
    }

    private RepMethod getMethodFromOldReport(RepClass oldRepClass, IMethod method) throws JavaModelException {
        if (oldRepClass == null) {
            return null;
        }
        for (RepMethod repMethod : oldRepClass.getMethods()) {
            if (!repMethod.getId().equals(method.getElementName()) || !repMethod.getSignature().equals(method.getSignature())) continue;
            return repMethod;
        }
        return null;
    }

    private RepProject readReport(IJavaProject testProject) throws CoreException {
        IFolder reportContainer = this.getReportContainer(testProject);
        IFile oldReport = null;
        String lastDate = "";
        IResource[] iResourceArray = reportContainer.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile && (fileName = resource.getName()).startsWith("necessaryTestsReport_")) {
                int lastIndexOf = fileName.lastIndexOf("_");
                String actualDate = fileName.substring(lastIndexOf + 1);
                if (!(actualDate = actualDate.replace(".xml", "")).equals(this.getTodayDate()) && actualDate.compareTo(lastDate) >= 1) {
                    lastDate = actualDate;
                    oldReport = (IFile)resource;
                }
            }
            ++n2;
        }
        if (oldReport == null || !oldReport.exists()) {
            return null;
        }
        RepProject repProject = null;
        try {
            oldReport.refreshLocal(0, null);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RepProject.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            repProject = (RepProject)unmarshaller.unmarshal(oldReport.getContents());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return repProject;
    }

    private boolean incrementTask(IProgressMonitor monitor, int i) {
        if (monitor.isCanceled()) {
            return true;
        }
        monitor.worked(i);
        return false;
    }

    private void writeReport(IJavaProject project, RepProject repProject) throws JUTWarning, CoreException, JAXBException, IOException {
        IFolder reportsContainer = this.getReportContainer(project);
        IFile reportFile = reportsContainer.getFile("necessaryTestsReport_" + this.getTodayDate() + ".xml");
        if (reportFile == null) {
            throw new JUTWarning("The report file could not be created!");
        }
        if (!reportFile.exists()) {
            byte[] bytes = "".getBytes();
            ByteArrayInputStream source = new ByteArrayInputStream(bytes);
            reportFile.create((InputStream)source, 0, null);
            ((InputStream)source).close();
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RepProject.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        FileWriter fileWriter = new FileWriter(reportFile.getRawLocation().makeAbsolute().toFile());
        marshaller.marshal((Object)repProject, (Writer)fileWriter);
        fileWriter.flush();
        fileWriter.close();
        reportFile.refreshLocal(0, null);
    }

    private IFolder getReportContainer(IJavaProject project) {
        IFolder reportContainer = JDTUtils.createFolder(project, "reports");
        if (!reportContainer.exists()) {
            throw new RuntimeException("Report-container could not be created");
        }
        return reportContainer;
    }

    private Report createReportEntry(JUTElements elements, Map.Entry<IMethod, MethodAnalyzer.MethodAnalyzeResult> methodEntry) {
        Report report = this.of.createReport();
        MethodAnalyzer.MethodAnalyzeResult mar = methodEntry.getValue();
        report.setTestPrio(mar.getTestPrio().value());
        report.setIsTestAvailable(false);
        report.setIsTestNecessary(true);
        report.setCoveredWith("");
        report.setIsNew(true);
        GregorianCalendar gc = this.getTimestamp();
        XMLGregorianCalendar date = null;
        try {
            date = DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {}
        report.setDate(date);
        return report;
    }

    private GregorianCalendar getTimestamp() {
        GregorianCalendar gc = (GregorianCalendar)GregorianCalendar.getInstance();
        gc.setTimeInMillis(System.currentTimeMillis());
        return gc;
    }

    private String getTodayDate() {
        if ("".equals(this.todayDate)) {
            Date time = new Date(System.currentTimeMillis());
            this.todayDate = time.toString();
        }
        return this.todayDate;
    }

    public int countAllTestMethods(JUTElements utmElements, IProgressMonitor monitor) throws JUTException {
        IJavaProject testProject = utmElements.getProjects().getTestProject();
        if (testProject != null && testProject.exists()) {
            try {
                Vector<IJavaElement> allCompilationUnits = JDTUtils.collectCompilationUnits((IJavaElement)testProject);
                return this.countAllTestMethods(allCompilationUnits);
            }
            catch (Exception e) {
                throw new JUTException(e);
            }
        }
        return 0;
    }

    private int countAllTestMethods(Vector<IJavaElement> allCompilationUnits) throws JavaModelException {
        int counter = 0;
        for (IJavaElement element : allCompilationUnits) {
            counter += JDTUtils.getMethods(element, true, "test", true, "public").size();
        }
        return counter;
    }
}

