/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.refactoring;

import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.junit.tools.generator.model.JUTElements;
import org.junit.tools.generator.utils.GeneratorUtils;
import org.junit.tools.generator.utils.JDTUtils;

public class RenameTestElements
extends RenameParticipant {
    private IType oldBaseType = null;
    private IMethod oldBaseMethod = null;
    private String oldBaseMethodSignature = null;
    private IPackageFragment oldBasePackage = null;

    protected boolean initialize(Object element) {
        if (element instanceof IMethod) {
            this.oldBaseMethod = (IMethod)element;
            try {
                this.oldBaseMethodSignature = ((IMethod)element).getSignature();
            }
            catch (JavaModelException javaModelException) {
                this.oldBaseMethodSignature = null;
            }
        } else if (element instanceof IType) {
            this.oldBaseType = (IType)element;
        } else if (element instanceof IPackageFragment) {
            this.oldBasePackage = (IPackageFragment)element;
        }
        return true;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm1) throws CoreException {
        CompositeChange renameMethodNameChange = new CompositeChange("org.junit.tools refactor dependent test-methods");
        PerformChangeOperation change = new PerformChangeOperation(new Change(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Change perform(IProgressMonitor pm2) throws CoreException {
                ICompilationUnit testCu;
                block9: {
                    JUTElements utmElementsOld = null;
                    testCu = null;
                    try {
                        if (RenameTestElements.this.oldBaseType != null) {
                            utmElementsOld = JUTElements.initJUTElements(RenameTestElements.this.oldBaseType.getJavaProject(), RenameTestElements.this.oldBaseType.getCompilationUnit());
                            if (!utmElementsOld.getProjects().isBaseProjectSelected() || !utmElementsOld.getClassesAndPackages().getTestClass().exists()) {
                                return null;
                            }
                            testCu = utmElementsOld.getClassesAndPackages().getTestClass();
                            RenameTestElements.this.renameTestClass(testCu, RenameTestElements.this.getArguments().getNewName(), pm2);
                            break block9;
                        }
                        if (RenameTestElements.this.oldBaseMethod != null) {
                            utmElementsOld = JUTElements.initJUTElements(RenameTestElements.this.oldBaseMethod.getJavaProject(), RenameTestElements.this.oldBaseMethod.getCompilationUnit());
                            if (!utmElementsOld.getProjects().isBaseProjectSelected() || !utmElementsOld.getClassesAndPackages().getTestClass().exists()) {
                                return null;
                            }
                            testCu = utmElementsOld.getClassesAndPackages().getTestClass();
                            RenameTestElements.this.renameTestMethod(testCu, RenameTestElements.this.getArguments().getNewName(), pm2);
                            IPackageFragment testPackage = utmElementsOld.getClassesAndPackages().getTestPackage();
                            testPackage.createCompilationUnit(testCu.getElementName(), testCu.getSource(), true, pm2);
                            break block9;
                        }
                        if (RenameTestElements.this.oldBasePackage == null) {
                            return null;
                        }
                        utmElementsOld = JUTElements.initJUTElements(RenameTestElements.this.oldBasePackage.getJavaProject(), RenameTestElements.this.oldBasePackage);
                        if (!utmElementsOld.getProjects().isBaseProjectSelected()) break block9;
                        IPackageFragment newBasePackage = JDTUtils.getPackage(RenameTestElements.this.oldBasePackage.getJavaProject(), RenameTestElements.this.getArguments().getNewName(), false);
                        JUTElements utmElementsNew = JUTElements.initJUTElements(RenameTestElements.this.oldBasePackage.getJavaProject(), newBasePackage);
                        IPackageFragment testPackage = utmElementsOld.getClassesAndPackages().getTestPackage();
                        if (testPackage != null && testPackage.exists()) {
                            testPackage.rename(utmElementsNew.getClassesAndPackages().getTestPackageName(), true, pm2);
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getName()).warning("Refactoring not possible: " + e.getMessage());
                    }
                }
                if (testCu != null && testCu.exists()) {
                    return null;
                }
                return null;
            }

            public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
                return new RefactoringStatus();
            }

            public void initializeValidationData(IProgressMonitor pm) {
            }

            public String getName() {
                String ar = RenameTestElements.this.getArguments().getNewName();
                return ar;
            }

            public Object getModifiedElement() {
                return null;
            }
        });
        renameMethodNameChange.add(change.getChange());
        return renameMethodNameChange;
    }

    public String getName() {
        RenameArguments args = this.getArguments();
        String newName = args.getNewName();
        return newName;
    }

    protected void renameTestMethod(ICompilationUnit testCu, String newName, IProgressMonitor pm) {
        try {
            if (testCu != null) {
                testCu.makeConsistent(null);
                if (testCu.hasUnsavedChanges()) {
                    testCu.commitWorkingCopy(true, null);
                }
                IMethod methodToChange = null;
                String oldBaseMethodName = this.oldBaseMethod.getElementName();
                String oldTestMethodName = GeneratorUtils.createTestMethodName(oldBaseMethodName);
                IType testType = testCu.findPrimaryType();
                IMethod[] iMethodArray = testType.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod testMethod = iMethodArray[n2];
                    if (!testMethod.isConstructor()) {
                        if (testMethod.getElementName().equals(oldTestMethodName)) {
                            methodToChange = testMethod;
                        }
                        if (GeneratorUtils.checkMethodReference(this.oldBaseMethod.getElementName(), this.oldBaseMethodSignature, testMethod)) {
                            methodToChange = testMethod;
                            break;
                        }
                    }
                    ++n2;
                }
                if (methodToChange != null) {
                    String newTestMethodName = GeneratorUtils.createTestMethodName(newName);
                    methodToChange.rename(newTestMethodName, true, pm);
                    IMethod newTestMethod = testType.getMethod(newTestMethodName, methodToChange.getParameterTypes());
                    String newSource = this.refactorTestMethodBody(newTestMethod, this.oldBaseMethod.getElementName(), newName);
                    if (newSource != null) {
                        newTestMethod.delete(true, null);
                        testType.createMethod(newSource, null, true, pm);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getName()).warning(e.getMessage());
        }
    }

    protected String refactorTestMethodBody(IMethod method, String oldName, String newName) throws JavaModelException {
        String source = method.getSource();
        source = source.replaceAll("\"" + oldName + "\"", "\"" + newName + "\"");
        return source;
    }

    protected void renameTestClass(ICompilationUnit testCu, String newName, IProgressMonitor pm) {
        try {
            if (testCu != null) {
                IPackageFragment testPackage;
                ICompilationUnit testSuite;
                testCu.makeConsistent(null);
                if (testCu.hasUnsavedChanges()) {
                    testCu.commitWorkingCopy(true, null);
                }
                String newtestClassName = GeneratorUtils.createTestClassName(newName);
                String oldTestClassName = testCu.getElementName().replace(".java", "");
                testCu.rename(String.valueOf(newtestClassName) + ".java", false, pm);
                IJavaElement parent = testCu.getParent();
                if (parent instanceof IPackageFragment && (testSuite = (testPackage = (IPackageFragment)parent).getCompilationUnit("TestSuite.java")).exists()) {
                    String source = testSuite.getSource();
                    source = source.replace(String.valueOf(oldTestClassName) + ".class", String.valueOf(newtestClassName) + ".class");
                    testSuite.getBuffer().setContents(source);
                    testSuite.save(pm, true);
                    testSuite.commitWorkingCopy(true, pm);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getName()).warning(e.getMessage());
        }
    }
}

