/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.junit.tools.Activator;
import org.junit.tools.generator.ITestSuitesGenerator;
import org.junit.tools.generator.model.JUTElements;
import org.junit.tools.generator.utils.JDTUtils;

public class DeleteTestElements
extends DeleteParticipant {
    private ICompilationUnit deletedCu = null;
    private IPackageFragment deletedPackage = null;
    private IJavaProject deletedProject;

    protected boolean initialize(Object element) {
        if (element instanceof ICompilationUnit) {
            this.deletedCu = (ICompilationUnit)element;
        } else if (element instanceof IPackageFragment) {
            this.deletedPackage = (IPackageFragment)element;
        } else if (element instanceof IJavaProject) {
            this.deletedProject = (IJavaProject)element;
        }
        return true;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm1) throws CoreException {
        CompositeChange deleteTestElementsChange = new CompositeChange("org.junit.tools delete dependent test-elements");
        PerformChangeOperation change = new PerformChangeOperation(new Change(){

            /*
             * Enabled aggressive exception aggregation
             */
            public Change perform(IProgressMonitor pm2) throws CoreException {
                block16: {
                    JUTElements utmElements = null;
                    try {
                        if (DeleteTestElements.this.deletedCu != null) {
                            try {
                                utmElements = JUTElements.initJUTElements(DeleteTestElements.this.deletedCu.getJavaProject(), DeleteTestElements.this.deletedCu);
                            }
                            catch (Exception exception) {
                                return null;
                            }
                            ICompilationUnit testClass = utmElements.getClassesAndPackages().getTestClass();
                            if (utmElements.getProjects().isBaseProjectSelected() && utmElements.getProjects().isTestProjectFound()) {
                                if (testClass != null && testClass.exists()) {
                                    testClass.delete(true, pm2);
                                } else {
                                    return null;
                                }
                            }
                            for (ITestSuitesGenerator testSuiteGenerator : Activator.getDefault().getExtensionHandler().getTestSuitesGenerators()) {
                                testSuiteGenerator.deleteTestSuiteElement(utmElements.getClassesAndPackages().getTestPackage(), testClass);
                            }
                            break block16;
                        }
                        if (DeleteTestElements.this.deletedPackage != null) {
                            utmElements = JUTElements.initJUTElements(DeleteTestElements.this.deletedPackage.getJavaProject(), DeleteTestElements.this.deletedPackage);
                            if (utmElements.getProjects().isBaseProjectSelected() && utmElements.getProjects().isTestProjectFound()) {
                                IPackageFragment testPackage = utmElements.getClassesAndPackages().getTestPackage();
                                if (testPackage.hasSubpackages()) {
                                    ICompilationUnit[] iCompilationUnitArray = testPackage.getCompilationUnits();
                                    int n = iCompilationUnitArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        ICompilationUnit cu = iCompilationUnitArray[n2];
                                        cu.delete(true, pm2);
                                        ++n2;
                                    }
                                } else {
                                    JDTUtils.deletePackagesWithParents(testPackage);
                                }
                            }
                        } else if (DeleteTestElements.this.deletedProject != null && (utmElements = JUTElements.initJUTElements(DeleteTestElements.this.deletedProject)).getProjects().isBaseProjectSelected() && utmElements.getProjects().isTestProjectFound()) {
                            utmElements.getProjects().getTestProject().close();
                        }
                    }
                    catch (Exception exception) {}
                }
                return null;
            }

            public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
                return new RefactoringStatus();
            }

            public void initializeValidationData(IProgressMonitor pm) {
            }

            public String getName() {
                String ar = DeleteTestElements.this.getArguments().getClass().toString();
                return ar;
            }

            public Object getModifiedElement() {
                return null;
            }
        });
        deleteTestElementsChange.add(change.getChange());
        return deleteTestElementsChange;
    }

    public String getName() {
        return this.getArguments().getClass().toString();
    }
}

