/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.preferences;

import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.junit.tools.Activator;
import org.junit.tools.preferences.IJUTPreferenceConstants;

public class JUTPreferences
implements IJUTPreferenceConstants {
    private static String LIST_DELIMITER = ";";
    private static Boolean writeTML = null;
    private static String tmlContainer = null;
    private static String testProjectPostfix = null;
    private static String testPackagePostfix = null;
    private static String testMethodPrefix = null;
    private static String testMethodPostfix = null;
    private static String testClassSuperType = null;
    private static String testClassPostfix = null;
    private static String mockProject = null;
    private static String[] testMethodFilterName = null;
    private static String[] testMethodFilterModifier = null;

    public static boolean getPreferenceBoolean(String name) {
        return JUTPreferences.getPreferenceStore().getBoolean(name);
    }

    public static String getPreference(String name) {
        return JUTPreferences.getPreferenceStore().getString(name);
    }

    private static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public static String getTmlContainer() {
        if (tmlContainer == null) {
            tmlContainer = JUTPreferences.getPreference("TML_CONTAINER");
        }
        return tmlContainer;
    }

    public static boolean isWriteTML() {
        if (writeTML == null) {
            writeTML = JUTPreferences.getPreferenceBoolean("WRITE_TML");
        }
        return writeTML;
    }

    public static String getTestProjectPostfix() {
        if (testProjectPostfix == null) {
            testProjectPostfix = JUTPreferences.getPreference("TEST_PROJECT_POSTFIX");
        }
        return testProjectPostfix;
    }

    public static String getTestMethodPostfix() {
        if (testMethodPostfix == null) {
            testMethodPostfix = JUTPreferences.getPreference("TEST_METHOD_POSTFIX");
        }
        return testMethodPostfix;
    }

    protected static void setTestMethodFilterName(String[] testMethodFilterName) {
        JUTPreferences.testMethodFilterName = testMethodFilterName;
    }

    protected static void setTestMethodFilterModifier(String[] testmethodFilterModifier) {
        testMethodFilterModifier = testmethodFilterModifier;
    }

    public static String[] getTestMethodFilterName() {
        if (testMethodFilterName == null) {
            testMethodFilterName = JUTPreferences.convert(JUTPreferences.getPreference("TEST_METHOD_FILTER_NAME"));
        }
        return testMethodFilterName;
    }

    public static String[] getTestMethodFilterModifier() {
        if (testMethodFilterModifier == null) {
            testMethodFilterModifier = JUTPreferences.convert(JUTPreferences.getPreference("TEST_METHOD_FILTER_MODIFIER"));
        }
        return testMethodFilterModifier;
    }

    protected static void setTmlContainer(String tmlContainerPref) {
        tmlContainer = tmlContainerPref;
    }

    protected static void setWriteTML(Boolean writeTML) {
        JUTPreferences.writeTML = writeTML;
    }

    protected static void setTestProjectPostfix(String testProjectPostfixPref) {
        testProjectPostfix = testProjectPostfixPref;
    }

    protected static void setTestMethodPostfix(String testmethodPostfixPref) {
        testMethodPostfix = testmethodPostfixPref;
    }

    public static String getTestMethodPrefix() {
        if (testMethodPrefix == null) {
            testMethodPrefix = JUTPreferences.getPreference("TEST_METHOD_PREFIX");
        }
        return testMethodPrefix;
    }

    protected static void setTestMethodPrefix(String testMethodPrefix) {
        JUTPreferences.testMethodPrefix = testMethodPrefix;
    }

    public static String getTestClassSuperType() {
        if (testClassSuperType == null) {
            testClassSuperType = JUTPreferences.getPreference("TEST_CLASS_SUPER_TYPE");
        }
        return testClassSuperType;
    }

    protected static void setTestClassSuperType(String testClassSuperType) {
        JUTPreferences.testClassSuperType = testClassSuperType;
    }

    public static String[] convert(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, LIST_DELIMITER);
        int tokenCount = tokenizer.countTokens();
        String[] elements = new String[tokenCount];
        int i = 0;
        while (i < tokenCount) {
            elements[i] = tokenizer.nextToken();
            ++i;
        }
        return elements;
    }

    public static String convert(String[] values) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < values.length) {
            buffer.append(values[i]);
            buffer.append(LIST_DELIMITER);
            ++i;
        }
        return buffer.toString();
    }

    public static void initialize() {
        JUTPreferences.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "TEST_PROJECT_POSTFIX") {
                    JUTPreferences.setTestProjectPostfix((String)event.getNewValue());
                    return;
                }
                if (event.getProperty() == "TML_CONTAINER") {
                    JUTPreferences.setTmlContainer((String)event.getNewValue());
                    return;
                }
                if (event.getProperty() == "WRITE_TML") {
                    JUTPreferences.setWriteTML((Boolean)event.getNewValue());
                    return;
                }
                if (event.getProperty() == "TEST_PACKAGE_POSTFIX") {
                    JUTPreferences.setTestPackagePostfix((String)event.getNewValue());
                    return;
                }
                if (event.getProperty() == "TEST_METHOD_PREFIX") {
                    JUTPreferences.setTestMethodPrefix((String)event.getNewValue());
                    return;
                }
                if (event.getProperty() == "TEST_METHOD_POSTFIX") {
                    JUTPreferences.setTestMethodPostfix((String)event.getNewValue());
                    return;
                }
                if (event.getProperty() == "TEST_METHOD_FILTER_MODIFIER") {
                    JUTPreferences.setTestMethodFilterModifier(JUTPreferences.convert((String)event.getNewValue()));
                    return;
                }
                if (event.getProperty() == "TEST_CLASS_SUPER_TYPE") {
                    JUTPreferences.setTestClassSuperType((String)event.getNewValue());
                    return;
                }
                if (event.getProperty() == "TEST_CLASS_POSTFIX") {
                    JUTPreferences.setTestClassPostfix((String)event.getNewValue());
                    return;
                }
                if (event.getProperty() == "MOCK_PROJECT") {
                    JUTPreferences.setMockProject((String)event.getNewValue());
                    return;
                }
            }
        });
    }

    protected static void setTestPackagePostfix(String newValue) {
        testPackagePostfix = newValue;
    }

    public static String getTestPackagePostfix() {
        if (testPackagePostfix == null) {
            testPackagePostfix = JUTPreferences.getPreference("TEST_PACKAGE_POSTFIX");
        }
        return testPackagePostfix;
    }

    protected static void setTestClassPostfix(String newValue) {
        testClassPostfix = newValue;
    }

    public static String getTestClassPostfix() {
        if (testClassPostfix == null) {
            testClassPostfix = JUTPreferences.getPreference("TEST_CLASS_POSTFIX");
        }
        return testClassPostfix;
    }

    public static String getMockProject() {
        if (mockProject == null) {
            mockProject = JUTPreferences.getPreference("MOCK_PROJECT");
        }
        return mockProject;
    }

    public static void setMockProject(String mockProject) {
        JUTPreferences.mockProject = mockProject;
    }
}

