/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.handler;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.junit.tools.Activator;
import org.junit.tools.base.JUTWarning;
import org.junit.tools.messages.Messages;
import org.junit.tools.ui.utils.EclipseUIUtils;

public abstract class JUTHandler
implements IHandler {
    protected static ILog log = Activator.getLogger();
    protected static String pluginId = "org.junit.tools";
    protected String information = Messages.General_information;
    protected String warning = Messages.General_warning;
    protected String error = Messages.General_error;
    protected String errorMsg = Messages.General_error_processing;

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    protected void handleError(Exception e) {
        Shell shell = EclipseUIUtils.getShell();
        Status status = new Status(4, pluginId, e.getMessage(), (Throwable)e);
        log.log((IStatus)status);
        MessageDialog.openError((Shell)shell, (String)this.error, (String)(String.valueOf(this.errorMsg) + "\n" + e.getMessage()));
    }

    protected void handleWarning(JUTWarning e) {
        Shell shell = EclipseUIUtils.getShell();
        String warningMsg = e.getMessage();
        MessageDialog.openWarning((Shell)shell, (String)this.warning, (String)warningMsg);
    }
}

