/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.junit.tools.base.JUTWarning;
import org.junit.tools.base.MainController;
import org.junit.tools.handler.JUTHandler;
import org.junit.tools.messages.Messages;
import org.junit.tools.ui.utils.EclipseUIUtils;

public class GenerateTestClassHandler
extends JUTHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MainController ctrl = new MainController();
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = activeWorkbenchWindow.getSelectionService().getSelection();
        boolean result = false;
        try {
            if (selection instanceof IStructuredSelection) {
                result = ctrl.generateTestclass(activeWorkbenchWindow, (IStructuredSelection)selection);
            } else {
                IEditorInput editorInput = EclipseUIUtils.getEditorInput();
                if (editorInput instanceof IFileEditorInput) {
                    result = ctrl.generateTestclass(activeWorkbenchWindow, (IFileEditorInput)editorInput);
                }
            }
        }
        catch (JUTWarning e) {
            this.handleWarning(e);
        }
        catch (Exception e) {
            this.handleError(e);
        }
        if (result) {
            String information = Messages.General_information;
            MessageDialog.openInformation((Shell)activeWorkbenchWindow.getShell(), (String)information, (String)Messages.General_info_generation_successful);
        }
        return null;
    }
}

