/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.junit.tools.Activator;
import org.junit.tools.base.JUTWarning;
import org.junit.tools.generator.IMockClassGenerator;
import org.junit.tools.handler.JUTHandler;
import org.junit.tools.messages.Messages;
import org.junit.tools.ui.utils.EclipseUIUtils;

public class GenerateMockClassHandler
extends JUTHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow activeWorkbenchWindow = EclipseUIUtils.getActiveWorkbenchWindow();
        try {
            ISelection selection = activeWorkbenchWindow.getSelectionService().getSelection();
            ICompilationUnit result = null;
            IMockClassGenerator mockClassGenerator = Activator.getDefault().getExtensionHandler().getMockClassGenerator();
            if (selection instanceof IStructuredSelection) {
                result = mockClassGenerator.generate(activeWorkbenchWindow, (IStructuredSelection)selection);
            } else {
                IEditorInput editorInput = EclipseUIUtils.getEditorInput();
                if (editorInput instanceof IFileEditorInput) {
                    result = mockClassGenerator.generate(activeWorkbenchWindow, (IFileEditorInput)editorInput);
                }
            }
            if (result != null) {
                IWorkbenchPartSite site = activeWorkbenchWindow.getActivePage().getActivePart().getSite();
                EclipseUIUtils.organizeImports(site, result);
                EclipseUIUtils.format(site, result);
                String information = Messages.General_information;
                MessageDialog.openInformation((Shell)activeWorkbenchWindow.getShell(), (String)information, (String)Messages.General_info_generation_successful);
            }
        }
        catch (JUTWarning e) {
            this.handleWarning(e);
        }
        catch (Exception e) {
            this.handleError(e);
            return null;
        }
        return null;
    }
}

