/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.handler;

import java.util.Vector;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.junit.tools.Activator;
import org.junit.tools.base.JUTWarning;
import org.junit.tools.generator.IMockClassGenerator;
import org.junit.tools.generator.utils.JDTUtils;
import org.junit.tools.handler.JUTHandler;
import org.junit.tools.messages.Messages;
import org.junit.tools.ui.utils.EclipseUIUtils;

public class CleanMocksHandler
extends JUTHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            this.cleanMocks();
            MessageDialog.openInformation((Shell)EclipseUIUtils.getShell(), (String)this.information, (String)Messages.General_info_generation_successful);
        }
        catch (JUTWarning e) {
            this.handleWarning(e);
        }
        catch (Exception e) {
            this.handleError(e);
        }
        return null;
    }

    private void cleanMocks() throws JUTWarning, CoreException {
        IWorkbenchWindow activeWorkbenchWindow = EclipseUIUtils.getActiveWorkbenchWindow();
        ISelection selection = activeWorkbenchWindow.getSelectionService().getSelection();
        IMockClassGenerator mockClassGenerator = Activator.getDefault().getExtensionHandler().getMockClassGenerator();
        Vector<IJavaElement> elements = JDTUtils.getCompilationUnits(selection);
        for (IJavaElement element : elements) {
            if (!(element instanceof ICompilationUnit)) continue;
            mockClassGenerator.cleanMock((ICompilationUnit)element);
        }
    }
}

