/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.generator.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.tools.base.JUTWarning;
import org.junit.tools.generator.IGeneratorConstants;
import org.junit.tools.generator.ITestDataFactory;
import org.junit.tools.messages.Messages;
import org.junit.tools.ui.utils.EclipseUIUtils;

public class JDTUtils
implements IGeneratorConstants {
    private static Logger logger = Logger.getLogger(JDTUtils.class.getName());
    private static ICompilationUnit lastParsedCu = null;
    private static CompilationUnit parsedCu = null;

    public static CompilationUnit createASTRoot(ICompilationUnit cu) {
        if (lastParsedCu == cu) {
            return parsedCu;
        }
        lastParsedCu = cu;
        ASTParser parser = JDTUtils.createASTParser(cu);
        parsedCu = (CompilationUnit)parser.createAST(null);
        return parsedCu;
    }

    private static void collectCompilationUnits(IJavaElement[] javaElements, Vector<IJavaElement> compilationUnits, String filter) throws JavaModelException {
        IJavaElement[] iJavaElementArray = javaElements;
        int n = javaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            JDTUtils.collectCompilationUnits(javaElement, compilationUnits, filter);
            ++n2;
        }
    }

    public static Vector<IJavaElement> collectCompilationUnits(List<IJavaProject> javaProjects) throws JavaModelException {
        Vector<IJavaElement> compilationUnits = new Vector<IJavaElement>();
        for (IJavaElement iJavaElement : javaProjects) {
            JDTUtils.collectCompilationUnits(iJavaElement, compilationUnits, "");
        }
        return compilationUnits;
    }

    public static void collectCompilationUnits(IJavaElement javaElement, Vector<IJavaElement> compilationUnits) throws JavaModelException {
        JDTUtils.collectCompilationUnits(javaElement, compilationUnits, "");
    }

    public static Vector<IJavaElement> collectCompilationUnits(IJavaElement javaElement) throws JavaModelException {
        Vector<IJavaElement> selectedCompilationUnits = new Vector<IJavaElement>();
        JDTUtils.collectCompilationUnits(javaElement, selectedCompilationUnits, null);
        return selectedCompilationUnits;
    }

    public static void collectCompilationUnits(IJavaElement javaElement, Vector<IJavaElement> selectedCompilationUnits, String filter) throws JavaModelException {
        switch (javaElement.getElementType()) {
            case 8: {
                JDTUtils.addCompilationUnit(selectedCompilationUnits, ((IField)javaElement).getCompilationUnit(), filter);
                break;
            }
            case 9: {
                JDTUtils.addCompilationUnit(selectedCompilationUnits, ((IMethod)javaElement).getCompilationUnit(), filter);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                JDTUtils.collectCompilationUnits(((IJavaProject)javaElement).getChildren(), selectedCompilationUnits, filter);
                break;
            }
            case 3: {
                JDTUtils.collectCompilationUnits(((IPackageFragmentRoot)javaElement).getChildren(), selectedCompilationUnits, filter);
                break;
            }
            case 4: {
                JDTUtils.collectCompilationUnits((IPackageFragment)javaElement, selectedCompilationUnits, filter);
                break;
            }
            case 5: {
                JDTUtils.addCompilationUnit(selectedCompilationUnits, (ICompilationUnit)javaElement, filter);
                break;
            }
            case 7: {
                JDTUtils.addCompilationUnit(selectedCompilationUnits, (IType)javaElement, filter);
                break;
            }
            case 6: {
                JDTUtils.addCompilationUnit(selectedCompilationUnits, (IClassFile)javaElement, filter);
            }
        }
    }

    private static void addCompilationUnit(Vector<IJavaElement> selectedCompilationUnits, IClassFile classFile, String filter) {
        selectedCompilationUnits.add((IJavaElement)classFile);
    }

    private static void addCompilationUnit(Vector<IJavaElement> selectedCompilationUnits, IType type, String filter) {
        JDTUtils.addCompilationUnit(selectedCompilationUnits, type.getCompilationUnit(), filter);
    }

    private static void addCompilationUnit(Vector<IJavaElement> selectedCompilationUnits, ICompilationUnit cu, String filter) {
        if (filter == null || "".equals(filter)) {
            selectedCompilationUnits.add((IJavaElement)cu);
        } else if (cu.getElementName().startsWith(filter)) {
            selectedCompilationUnits.add((IJavaElement)cu);
        }
    }

    private static void collectCompilationUnits(IPackageFragment pkgFrgmt, Vector<IJavaElement> selectedCompilationUnits, String filter) throws JavaModelException {
        ICompilationUnit[] compilationUnits;
        ICompilationUnit[] iCompilationUnitArray = compilationUnits = pkgFrgmt.getCompilationUnits();
        int n = compilationUnits.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            JDTUtils.addCompilationUnit(selectedCompilationUnits, cu, filter);
            ++n2;
        }
    }

    public static IJavaProject getProject(ISelection selection) {
        return JDTUtils.getProject(selection, null);
    }

    public static IJavaProject getProject(ISelection selection, IFileEditorInput fileEditorInput) {
        Object firstElement;
        IProject project = null;
        if (fileEditorInput != null) {
            firstElement = fileEditorInput;
        } else {
            firstElement = EclipseUIUtils.getFirstSelectedElement(selection);
            if (firstElement == null) {
                return null;
            }
        }
        if (firstElement instanceof IJavaElement) {
            return JDTUtils.getProject((IJavaElement)firstElement);
        }
        if (firstElement instanceof IJavaProject) {
            return (IJavaProject)firstElement;
        }
        if (firstElement instanceof IProject) {
            project = (IProject)firstElement;
        } else if (firstElement instanceof IFile) {
            IFile file = (IFile)firstElement;
            project = file.getProject();
        } else if (firstElement instanceof IFileEditorInput) {
            Object fileEditorInputTmp = firstElement;
            project = fileEditorInputTmp.getFile().getProject();
        } else if (firstElement instanceof ICompilationUnit) {
            ICompilationUnit compilationUnit = (ICompilationUnit)firstElement;
            return compilationUnit.getJavaProject();
        }
        if (project == null) {
            return null;
        }
        return JDTUtils.convertToJavaProject(project);
    }

    public static IJavaProject convertToJavaProject(IProject project) {
        IJavaProject jProject;
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                throw new RuntimeException(Messages.GeneratorUtils_OnlyJavaProjects);
            }
            jProject = JavaCore.create((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
        return jProject;
    }

    public static IFolder createFolder(IJavaProject jproject, String folderName) {
        IFolder folder = jproject.getProject().getFolder(folderName);
        try {
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            throw new RuntimeException(Messages.GeneratorUtils_ErrorPackageCreation);
        }
        return folder;
    }

    public static IPackageFragment getPackage(IJavaProject javaProject, String name, boolean createIfNotExists) throws CoreException {
        IPackageFragmentRoot parentFolder;
        IPackageFragment packageFragment;
        IFolder folder = javaProject.getProject().getFolder("src");
        if (!folder.exists()) {
            if (createIfNotExists) {
                folder.create(true, true, null);
            } else {
                return null;
            }
        }
        if ((packageFragment = (parentFolder = javaProject.getPackageFragmentRoot((IResource)folder)).getPackageFragment(name)) == null || !packageFragment.exists()) {
            packageFragment = createIfNotExists ? parentFolder.createPackageFragment(name, true, null) : parentFolder.getPackageFragment(name);
        }
        return packageFragment;
    }

    public static List<IPackageFragment> getSubPackages(IPackageFragment p) throws JavaModelException {
        IJavaElement[] children;
        ArrayList<IPackageFragment> result = new ArrayList<IPackageFragment>();
        IJavaElement[] iJavaElementArray = children = ((IPackageFragmentRoot)p.getParent()).getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (element instanceof IPackageFragment && JDTUtils.isParentPackage(p.getElementName(), element.getElementName())) {
                result.add((IPackageFragment)element);
            }
            ++n2;
        }
        return result;
    }

    public static IPackageFragment createPackage(IJavaProject javaProject, String name) throws CoreException {
        return JDTUtils.getPackage(javaProject, name, true);
    }

    public static IPackageFragment createPackage(IJavaProject javaProject, String parentFolderName, String name) throws CoreException {
        IPackageFragmentRoot parentFolder;
        IPackageFragment packageFragment;
        IFolder folder = javaProject.getProject().getFolder(parentFolderName);
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        if ((packageFragment = (parentFolder = javaProject.getPackageFragmentRoot((IResource)folder)).getPackageFragment(name)) == null || !packageFragment.exists()) {
            packageFragment = parentFolder.createPackageFragment(name, true, null);
        }
        return packageFragment;
    }

    public static IJavaProject createProject(String name) throws CoreException {
        return JDTUtils.createProject(name, null);
    }

    public static IJavaProject createProject(String name, IJavaProject baseProject) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(name);
        if (project.exists()) {
            return JavaCore.create((IProject)project);
        }
        project.create(null);
        project.open(null);
        IProjectDescription description = project.getDescription();
        project.setDescription(description, null);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (baseProject != null) {
            description.setNatureIds(baseProject.getProject().getDescription().getNatureIds());
            Vector<IClasspathEntry> buildPath = new Vector<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = baseProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() != 3) {
                    buildPath.add(entry);
                }
                ++n2;
            }
            buildPath.add(JavaCore.newSourceEntry((IPath)javaProject.getPath().append("src")));
            buildPath.add(JavaCore.newProjectEntry((IPath)baseProject.getPath()));
            IClasspathEntry[] entries = new IClasspathEntry[buildPath.size()];
            entries = buildPath.toArray(entries);
            javaProject.setRawClasspath(entries, null);
        }
        return javaProject;
    }

    public static IJavaProject getProject(IJavaElement javaElement) {
        return (IJavaProject)javaElement.getAncestor(2);
    }

    public static IJavaProject getProject(String name) {
        return JDTUtils.getProject(name, false, null);
    }

    public static IJavaProject getProject(String name, boolean createIfNotExists, IJavaProject baseProject) {
        IProject[] iProjectArray = JDTUtils.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getName().equals(name)) {
                return JDTUtils.convertToJavaProject(project);
            }
            ++n2;
        }
        if (createIfNotExists) {
            try {
                return JDTUtils.createProject(name, baseProject);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static IProject[] getProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        return projects;
    }

    public static List<IJavaProject> getJavaProjects() {
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        IProject[] iProjectArray = JDTUtils.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IJavaProject javaProject;
                IProject project = iProjectArray[n2];
                try {
                    javaProject = JDTUtils.convertToJavaProject(project);
                }
                catch (Exception exception) {
                    break block4;
                }
                if (javaProject != null) {
                    javaProjects.add(javaProject);
                }
            }
            ++n2;
        }
        return javaProjects;
    }

    public static IPackageFragment getPackage(IJavaElement javaElement) {
        IJavaElement tmp = javaElement.getAncestor(4);
        if (tmp == null) {
            return null;
        }
        return (IPackageFragment)tmp;
    }

    public static IMethod createMethod(IType type, String modifier, String returnType, String methodName, String throwsClause, String params, String body, String ... annotations) throws JavaModelException {
        return JDTUtils.createMethod(type, modifier, returnType, methodName, throwsClause, params, body, true, annotations);
    }

    public static IMethod createMethod(IType type, String modifier, String returnType, String methodName, String throwsClause, String params, String body, boolean increment, String ... annotations) throws JavaModelException {
        return JDTUtils.createMethod(type, modifier, returnType, methodName, throwsClause, params, body, true, false, annotations);
    }

    public static IMethod createMethod(IType type, IMethod method, String body, String annotations) throws JavaModelException {
        return JDTUtils.createMethod(type, method, method.getElementName(), body, annotations);
    }

    public static IMethod createMethod(IType type, IMethod method, String methodName, String body, String annotations) throws JavaModelException {
        String modifier = JDTUtils.getMethodModifier(method);
        String returnType = JDTUtils.createReturnType(method.getReturnType());
        String params = JDTUtils.createParamList(method);
        String throwsClause = "";
        String comma = "";
        String[] stringArray = method.getExceptionTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String exceptionType = stringArray[n2];
            throwsClause = String.valueOf(comma) + exceptionType;
            comma = ",";
            ++n2;
        }
        return JDTUtils.createMethod(type, modifier, returnType, methodName, throwsClause, params, body, false, true, annotations);
    }

    public static IMethod createMethod(IType type, IMethod method) throws JavaModelException {
        String returnType = JDTUtils.createReturnType(method.getReturnType());
        String body = "";
        if (!"void".equals(returnType)) {
            body = "return " + JDTUtils.createInitValue(returnType, true) + ";";
        }
        return JDTUtils.createMethod(type, method, body, "");
    }

    public static IMethod createMethod(IType type, IMethod method, String annotation) throws JavaModelException {
        String returnType = JDTUtils.createReturnType(method.getReturnType());
        String body = "";
        if (!"void".equals(returnType)) {
            body = "return " + JDTUtils.createInitValue(returnType, true) + ";";
        }
        return JDTUtils.createMethod(type, method, body, annotation);
    }

    public static IMethod createMethod(IType type, String modifier, String returnType, String methodName, String throwsClause, String params, String body, boolean increment, boolean force, String ... annotations) throws JavaModelException {
        IMethod tmpMethod = type.getMethod(methodName, null);
        StringBuilder sbMethod = new StringBuilder();
        if (force && tmpMethod.exists()) {
            tmpMethod.delete(true, null);
        }
        if (increment) {
            while (tmpMethod.exists()) {
                methodName = JDTUtils.increment(methodName, "_");
                tmpMethod = type.getMethod(methodName, null);
            }
        }
        if (annotations != null) {
            String[] stringArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                String annotation = stringArray[n2];
                if (!annotation.startsWith("@")) {
                    annotation = "@" + annotation;
                }
                sbMethod.append(annotation);
                sbMethod.append("\n");
                ++n2;
            }
        }
        throwsClause = throwsClause != null && throwsClause.length() > 0 ? "throws " + throwsClause : "";
        if (returnType == null) {
            returnType = "";
        }
        if (params == null) {
            params = "";
        }
        sbMethod.append(modifier).append(" ").append(returnType).append(" ").append(methodName).append("(").append(params).append(") " + throwsClause + " {\n").append(body).append("\n}");
        try {
            tmpMethod = type.createMethod(sbMethod.toString(), null, force, null);
        }
        catch (Exception ex) {
            logger.severe(ExceptionUtils.getFullStackTrace((Throwable)ex));
        }
        return tmpMethod;
    }

    public static String increment(String input, String incrementSeperator) {
        if (incrementSeperator == null) {
            incrementSeperator = "_";
        }
        int inputLength = input.length();
        int incrementSeperatorIx = JDTUtils.getIncrementSeperatorIndex(input, incrementSeperator);
        if (incrementSeperatorIx != -1) {
            int firstNumberIndex = incrementSeperatorIx + 1;
            int postfixNumber = firstNumberIndex < inputLength ? Integer.parseInt(input.substring(incrementSeperatorIx + 1, inputLength)) : 0;
            input = String.valueOf(input.substring(0, incrementSeperatorIx + 1)) + ++postfixNumber;
        } else {
            input = String.valueOf(input) + incrementSeperator + "1";
        }
        return input;
    }

    private static int getIncrementSeperatorIndex(String input, String incrementSeperator) {
        int lastLetterIndex;
        if (incrementSeperator == null) {
            incrementSeperator = "_";
        }
        String lastLetter = "";
        int inputLength = input.length();
        int i = lastLetterIndex = inputLength - 1;
        while (i >= 0) {
            lastLetter = input.substring(i, i + 1);
            try {
                Integer.parseInt(lastLetter);
            }
            catch (NumberFormatException numberFormatException) {
                lastLetterIndex = i;
                break;
            }
            --i;
        }
        if (lastLetter.equals(incrementSeperator)) {
            return lastLetterIndex;
        }
        return -1;
    }

    public static List<IMethod> getMethods(IJavaElement javaElement, boolean withSubTypes) throws JavaModelException {
        return JDTUtils.getMethods(javaElement, withSubTypes, null);
    }

    public static List<IMethod> getMethods(IJavaElement javaElement, boolean withSubTypes, String nameFilter) throws JavaModelException {
        return JDTUtils.getMethods(javaElement, withSubTypes, nameFilter, false, null);
    }

    public static List<IMethod> getMethods(IJavaElement javaElement, boolean withSubTypes, String nameFilter, boolean startsWith, String modifierFilter) throws JavaModelException {
        IType[] types;
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        ICompilationUnit cu = null;
        if (javaElement instanceof ICompilationUnit) {
            cu = (ICompilationUnit)javaElement;
            types = cu.getAllTypes();
        } else if (javaElement instanceof IClassFile) {
            javaElement = ((IClassFile)javaElement).findPrimaryType();
        }
        if (javaElement instanceof IType) {
            return JDTUtils.getMethods((IType)javaElement, nameFilter, startsWith, modifierFilter);
        }
        if (cu == null) {
            return methods;
        }
        types = withSubTypes ? cu.getAllTypes() : new IType[]{cu.findPrimaryType()};
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            methods.addAll(JDTUtils.getMethods(type, nameFilter, startsWith, modifierFilter));
            ++n2;
        }
        return methods;
    }

    public static List<IMethod> getMethods(IType type, String nameFilter, boolean startsWith, String modifierFilter) throws JavaModelException {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (JDTUtils.validateMethod(method, nameFilter, startsWith, modifierFilter)) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    public static boolean validateMethod(IMethod method, String nameFilter, boolean startsWith, String modifierFilter) throws JavaModelException {
        String methodModifier;
        String methodName = method.getElementName();
        if (nameFilter != null && (startsWith ? !methodName.startsWith(nameFilter) : !nameFilter.equals(methodName))) {
            return false;
        }
        return modifierFilter == null || modifierFilter.equals(methodModifier = JDTUtils.getMethodModifier(method));
    }

    public static List<IMethod> getMethods(ICompilationUnit cu) throws JavaModelException {
        return JDTUtils.getMethods((IJavaElement)cu, true);
    }

    public static MethodDeclaration createMethodDeclaration(CompilationUnit cu, IMethod method) {
        ASTNode declaringNode = null;
        if (method.isResolved()) {
            declaringNode = cu.findDeclaringNode(method.getKey());
        } else {
            IBinding[] iBindingArray = JDTUtils.createBindings(method.getCompilationUnit(), new IJavaElement[]{method});
            int n = iBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBinding binding = iBindingArray[n2];
                if (binding instanceof IMethodBinding) {
                    declaringNode = cu.findDeclaringNode(((IMethodBinding)binding).getKey());
                    break;
                }
                ++n2;
            }
        }
        if (!(declaringNode instanceof MethodDeclaration)) {
            return null;
        }
        return (MethodDeclaration)declaringNode;
    }

    public static int getIncrement(String input, String incrementSeperator) {
        int incrementIx;
        if (incrementSeperator == null) {
            incrementSeperator = "_";
        }
        if ((incrementIx = JDTUtils.getIncrementSeperatorIndex(input, incrementSeperator)) != -1) {
            try {
                return Integer.parseInt(input.substring(incrementIx + 1));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    public static MethodDeclaration getASTMethod(ASTNode node) {
        if (node instanceof MethodDeclaration) {
            return (MethodDeclaration)node;
        }
        if (node != null && node.getParent() != null) {
            return JDTUtils.getASTMethod(node.getParent());
        }
        return null;
    }

    private static String getFullQualifiedName(IImportDeclaration[] imports, String paramType) {
        if (imports == null) {
            return null;
        }
        IImportDeclaration[] iImportDeclarationArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IImportDeclaration importDeclaration = iImportDeclarationArray[n2];
            String importFullQualifiedName = importDeclaration.getElementName();
            String importType = importFullQualifiedName.substring(importFullQualifiedName.lastIndexOf(".") + 1);
            if (paramType.equals(importType)) {
                return importFullQualifiedName;
            }
            ++n2;
        }
        return null;
    }

    public static String getFullQualifiedName(IType type, ILocalVariable variableToSearch) throws JavaModelException {
        String variableTypeName = Signature.getSignatureSimpleName((String)variableToSearch.getTypeSignature());
        return JDTUtils.getFullQualifiedName(type, variableTypeName);
    }

    public static String getFullQualifiedName(IType type, String variableTypeName) throws JavaModelException {
        IImportDeclaration[] imports = null;
        List importsFromBinary = null;
        ICompilationUnit cu = type.getCompilationUnit();
        if (cu != null) {
            imports = cu.getImports();
        } else {
            ASTParser parser = ASTParser.newParser((int)4);
            parser.setSource(type.getClassFile().getBuffer().getCharacters());
            CompilationUnit cuParsed = (CompilationUnit)parser.createAST(null);
            if (cuParsed != null) {
                importsFromBinary = cuParsed.imports();
            }
        }
        String fullQualifiedName = null;
        if (imports != null) {
            fullQualifiedName = JDTUtils.getFullQualifiedName(imports, variableTypeName);
        } else if (importsFromBinary != null) {
            fullQualifiedName = JDTUtils.getFullQualifiedName(importsFromBinary, variableTypeName);
        }
        if (fullQualifiedName == null) {
            fullQualifiedName = String.valueOf(type.getPackageFragment().getElementName()) + "." + variableTypeName;
        }
        return fullQualifiedName;
    }

    private static String getFullQualifiedName(List<?> importsFromBinary, String paramTypeName) {
        for (Object importFromBinary : importsFromBinary) {
            String importFromBinaryS = importFromBinary.toString().replace("\\n", "").replace("\n", "").replace(";", "");
            int lastIndexOf = importFromBinaryS.lastIndexOf(".");
            lastIndexOf = lastIndexOf == -1 ? 0 : ++lastIndexOf;
            String typeName = importFromBinaryS.substring(lastIndexOf);
            if (!paramTypeName.equals(typeName)) continue;
            return importFromBinaryS.replace("import", "").trim();
        }
        return null;
    }

    public static String getMethodModifier(IMethod method) throws JavaModelException {
        int methodFlags = method.getFlags();
        if (Flags.isPublic((int)methodFlags)) {
            return "public";
        }
        if (Flags.isProtected((int)methodFlags)) {
            return "protected";
        }
        if (Flags.isPrivate((int)methodFlags)) {
            return "private";
        }
        if (Flags.isPackageDefault((int)methodFlags)) {
            return "";
        }
        return "";
    }

    private static ASTParser createASTParser(ICompilationUnit cu) {
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setProject(cu.getJavaProject());
        parser.setUnitName(cu.getElementName());
        parser.setResolveBindings(true);
        parser.setSource(cu);
        return parser;
    }

    public static IField createField(IType type, String modifier, String fieldType, String fieldName, String assignment, boolean increment) throws JavaModelException {
        if (increment) {
            while (type.getField(fieldName).exists()) {
                fieldName = JDTUtils.increment(fieldName, "_");
            }
        }
        IField createdField = type.createField(String.valueOf(modifier) + " " + fieldType + " " + fieldName + " = " + assignment + ";", null, true, null);
        return createdField;
    }

    public static IBinding[] createBindings(ICompilationUnit cu, IJavaElement ... javaElements) {
        ASTParser parser = JDTUtils.createASTParser(cu);
        return parser.createBindings(javaElements, null);
    }

    public static boolean isMethodNameUnique(IMethod method) throws JavaModelException {
        IMethod[] methods;
        int methodCount = 0;
        IType type = (IType)method.getParent();
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod tmpMethod = iMethodArray[n2];
            if (tmpMethod.getElementName().equals(method.getElementName())) {
                ++methodCount;
            }
            ++n2;
        }
        return methodCount <= 1;
    }

    public static IPackageFragment getParentPackage(IPackageFragment p) {
        String parentPackageName;
        if (p.isDefaultPackage()) {
            return null;
        }
        int index = p.getElementName().lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)p.getParent();
        IPackageFragment parent = root.getPackageFragment(parentPackageName = p.getElementName().substring(0, index));
        if (parent.exists()) {
            return parent;
        }
        return null;
    }

    public static void deletePackages(IPackageFragment packageToDelete) throws JavaModelException {
        if (!packageToDelete.hasSubpackages()) {
            JDTUtils.deletePackagesWithParents(packageToDelete);
        }
    }

    public static void deletePackagesWithParents(IPackageFragment packageToDelete) throws JavaModelException {
        if (packageToDelete == null) {
            return;
        }
        packageToDelete.delete(true, null);
        IPackageFragment parentPackage = JDTUtils.getParentPackage(packageToDelete);
        if (parentPackage.getCompilationUnits().length == 0) {
            JDTUtils.deletePackagesWithParents(parentPackage);
        }
    }

    public static boolean isParentPackage(String parentPackage, String childPackage) {
        int childPackageSegmentSize;
        int parentPackageSegmentSize = parentPackage.split("\\.").length;
        return parentPackageSegmentSize != (childPackageSegmentSize = childPackage.split("\\.").length) && childPackage.startsWith(parentPackage);
    }

    public static String createClassCreationChain(IType baseType, StringBuilder classCreationChain, List<ITestDataFactory> testDataFactories) {
        block7: {
            try {
                try {
                    classCreationChain.append("new ").append(baseType.getElementName()).append("(");
                    IMethod[] iMethodArray = baseType.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method = iMethodArray[n2];
                        if (method.isConstructor()) {
                            JDTUtils.createClassCreationChain(baseType, method, classCreationChain, testDataFactories);
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    classCreationChain.append("null");
                    classCreationChain.append(")");
                    break block7;
                }
            }
            catch (Throwable throwable) {
                classCreationChain.append(")");
                throw throwable;
            }
            classCreationChain.append(")");
        }
        return classCreationChain.toString();
    }

    private static void createClassCreationChain(IType baseType, IMethod constructor, StringBuilder classCreationChain, List<ITestDataFactory> testDataFactories) throws JavaModelException {
        ILocalVariable[] params = constructor.getParameters();
        if (params != null && params.length != 0) {
            String comma = "";
            ILocalVariable[] iLocalVariableArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalVariable param = iLocalVariableArray[n2];
                classCreationChain.append(comma);
                String typeSignature = param.getTypeSignature();
                int typeSignatureKind = Signature.getTypeSignatureKind((String)typeSignature);
                String signatureSimpleName = Signature.getSignatureSimpleName((String)typeSignature);
                if (2 == typeSignatureKind || JDTUtils.isString(signatureSimpleName)) {
                    if (!"void".equals(Signature.getSimpleName((String)typeSignature))) {
                        classCreationChain.append(JDTUtils.decorateValue(JDTUtils.createInitValue(signatureSimpleName), signatureSimpleName));
                    }
                } else {
                    IType paramType = null;
                    String fullQualifiedName = JDTUtils.getFullQualifiedName(baseType, param);
                    try {
                        paramType = baseType.getJavaProject().findType(fullQualifiedName);
                    }
                    catch (JavaModelException javaModelException) {
                        paramType = null;
                    }
                    if (paramType != null) {
                        boolean creationDone = false;
                        for (ITestDataFactory testDataFactory : testDataFactories) {
                            creationDone = testDataFactory.createTypeCreation(paramType, classCreationChain);
                        }
                        if (paramType.getFullyQualifiedName().equals(baseType.getFullyQualifiedName())) {
                            classCreationChain.append("null");
                        } else if (!creationDone) {
                            JDTUtils.createClassCreationChain(paramType, classCreationChain, testDataFactories);
                        }
                    } else {
                        classCreationChain.append("null");
                    }
                }
                comma = ", ";
                ++n2;
            }
        }
    }

    public static boolean isMethodModifierEqual(IMethod method, String modifier) {
        String methodModifier;
        try {
            methodModifier = JDTUtils.getMethodModifier(method);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        return methodModifier.equals(modifier);
    }

    public static boolean isStatic(IMethod method) throws JavaModelException {
        return Flags.isStatic((int)method.getFlags());
    }

    public static boolean isNumber(String type) {
        return JDTUtils.isInt(type) || JDTUtils.isInteger(type) || JDTUtils.isDouble(type) || JDTUtils.isFloat(type);
    }

    public static boolean isString(String type) {
        return type.startsWith("String");
    }

    public static String createReturnType(String returnType) {
        returnType = returnType != null && !returnType.equals("V") ? Signature.getSignatureSimpleName((String)returnType) : "void";
        return returnType;
    }

    public static String formatValue(String value, String type) {
        String resultValue = "";
        if (value == null || value.length() == 0) {
            resultValue = JDTUtils.createInitValue(type);
            resultValue = JDTUtils.decorateValue(resultValue, type);
        } else if (JDTUtils.isArray(type)) {
            String[] values = value.split(",");
            boolean firstValue = true;
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String tmpValue = stringArray[n2];
                if ("".equals(tmpValue = tmpValue.trim())) {
                    tmpValue = JDTUtils.createInitValue(type);
                }
                tmpValue = JDTUtils.decorateValue(tmpValue, type);
                if (firstValue) {
                    resultValue = tmpValue;
                    firstValue = false;
                } else {
                    resultValue = String.valueOf(resultValue) + ", " + tmpValue;
                }
                ++n2;
            }
        } else {
            resultValue = JDTUtils.decorateValue(value, type);
        }
        if (JDTUtils.isArray(type)) {
            resultValue = "new " + type + "{" + resultValue + "}";
        }
        return resultValue;
    }

    public static String createInitValue(String type) {
        return JDTUtils.createInitValue(type, false);
    }

    public static String createInitValue(String type, boolean formatValue) {
        String value = JDTUtils.isString(type) || JDTUtils.isChar(type) ? "" : (JDTUtils.isByte(type) ? " " : (JDTUtils.isBoolean(type) ? "false" : (JDTUtils.isNumber(type) ? (JDTUtils.isDouble(type) ? "0.0" : "0") : "null")));
        if (formatValue) {
            value = JDTUtils.formatValue(value, type);
        }
        return value;
    }

    public static String createParamList(IMethod method) throws JavaModelException {
        return JDTUtils.createParamList(method, true);
    }

    public static String createParamList(IMethod method, boolean withParamTypes) throws JavaModelException {
        StringBuilder params = new StringBuilder();
        String comma = "";
        ILocalVariable[] iLocalVariableArray = method.getParameters();
        int n = iLocalVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalVariable variable = iLocalVariableArray[n2];
            params.append(comma);
            comma = ", ";
            if (withParamTypes) {
                params.append(Signature.getSignatureSimpleName((String)variable.getTypeSignature())).append(" ");
            }
            params.append(variable.getElementName());
            ++n2;
        }
        return params.toString();
    }

    public static String decorateValue(String value, String type) {
        if (JDTUtils.isString(type)) {
            value = "\"" + value + "\"";
        } else if (JDTUtils.isChar(type) || JDTUtils.isByte(type)) {
            if (value.length() == 0) {
                value = " ";
            }
            value = "'" + value + "'";
        }
        return value;
    }

    public static boolean isArray(String type) {
        return type.endsWith("[]");
    }

    public static boolean isBoolean(String type) {
        return type.startsWith("boolean");
    }

    public static boolean isChar(String type) {
        return type.startsWith("char");
    }

    public static boolean isByte(String type) {
        return type.startsWith("byte");
    }

    public static boolean isDouble(String type) {
        return type.startsWith("double");
    }

    public static boolean isFloat(String type) {
        return type.startsWith("float");
    }

    public static boolean isInt(String type) {
        return type.startsWith("int");
    }

    public static boolean isInteger(String type) {
        return type.startsWith("Integer");
    }

    public static IMethod getSelectedMethod(IFileEditorInput fileEditorInput) {
        ITextEditor editor = (ITextEditor)EclipseUIUtils.getActiveEditor();
        ITextSelection sel = (ITextSelection)editor.getSelectionProvider().getSelection();
        ITypeRoot typeRoot = JavaUI.getEditorInputTypeRoot((IEditorInput)editor.getEditorInput());
        ICompilationUnit icu = (ICompilationUnit)typeRoot.getAdapter(ICompilationUnit.class);
        CompilationUnit cu = JDTUtils.createASTRoot(icu);
        NodeFinder finder = new NodeFinder((ASTNode)cu, sel.getOffset(), sel.getLength());
        ASTNode node = finder.getCoveringNode();
        MethodDeclaration methodDeclaration = JDTUtils.getASTMethod(node);
        if (methodDeclaration == null) {
            return null;
        }
        IMethodBinding methodBinding = methodDeclaration.resolveBinding();
        IMethod selectedMethod = null;
        if (methodBinding != null) {
            selectedMethod = (IMethod)methodBinding.getJavaElement();
        }
        return selectedMethod;
    }

    public static IMethod getSelectedMethod() throws JavaModelException {
        ITextSelection sel;
        IJavaElement selected;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ITextEditor editor = (ITextEditor)page.getActiveEditor();
        IJavaElement elem = JavaUI.getEditorInputJavaElement((IEditorInput)editor.getEditorInput());
        if (elem instanceof ICompilationUnit && (selected = ((ICompilationUnit)elem).getElementAt((sel = (ITextSelection)editor.getSelectionProvider().getSelection()).getOffset())) != null && selected.getElementType() == 9) {
            return (IMethod)selected;
        }
        return null;
    }

    public static Vector<IJavaElement> getCompilationUnits(ISelection selection, IFileEditorInput fileEditorInput) throws JavaModelException, JUTWarning {
        Vector<IJavaElement> javaElements = JDTUtils.getJavaElements(selection, fileEditorInput);
        return javaElements;
    }

    public static Vector<IJavaElement> getJavaElements(ISelection selection, IFileEditorInput fileEditorInput, boolean withBinary) throws JavaModelException, JUTWarning {
        Object[] selectionArray;
        if (fileEditorInput != null) {
            selectionArray = new Object[]{fileEditorInput};
        } else {
            if (!(selection instanceof IStructuredSelection)) {
                return null;
            }
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selectionArray = structuredSelection.toArray();
        }
        Vector<IJavaElement> selectedCompilationUnits = new Vector<IJavaElement>();
        Object[] objectArray = selectionArray;
        int n = selectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object tmpSelection = objectArray[n2];
            if (tmpSelection instanceof IJavaElement) {
                IJavaElement javaElement = (IJavaElement)tmpSelection;
                JDTUtils.collectCompilationUnits(javaElement, selectedCompilationUnits);
            } else if (tmpSelection instanceof IParent) {
                IJavaElement[] javaElements;
                IParent parentSelection = (IParent)tmpSelection;
                IJavaElement[] iJavaElementArray = javaElements = parentSelection.getChildren();
                int n3 = javaElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement javaElement = iJavaElementArray[n4];
                    JDTUtils.collectCompilationUnits(javaElement, selectedCompilationUnits);
                    ++n4;
                }
            } else if (tmpSelection instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInputTmp = (IFileEditorInput)tmpSelection;
                IFile ifile = fileEditorInputTmp.getFile();
                if (ifile.getName().endsWith(".java")) {
                    ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)ifile);
                    selectedCompilationUnits.add((IJavaElement)cu);
                } else {
                    throw new JUTWarning(Messages.GeneratorUtils_SelectionEnd);
                }
            }
            ++n2;
        }
        return selectedCompilationUnits;
    }

    public static Vector<IJavaElement> getJavaElements(ISelection selection, IFileEditorInput fileEditorInput) throws JavaModelException, JUTWarning {
        return JDTUtils.getJavaElements(selection, fileEditorInput, false);
    }

    public static Vector<IJavaElement> getCompilationUnits(ISelection selection) throws JavaModelException, JUTWarning {
        if (selection instanceof IStructuredSelection) {
            return JDTUtils.getCompilationUnits(selection, null);
        }
        IEditorInput editorInput = EclipseUIUtils.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            return JDTUtils.getCompilationUnits(null, (IFileEditorInput)editorInput);
        }
        return new Vector<IJavaElement>();
    }
}

