/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.generator.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.junit.tools.base.MethodRef;
import org.junit.tools.generator.IGeneratorConstants;
import org.junit.tools.generator.model.tml.Method;
import org.junit.tools.generator.model.tml.Param;
import org.junit.tools.generator.utils.JDTUtils;
import org.junit.tools.preferences.JUTPreferences;

public class GeneratorUtils
implements IGeneratorConstants {
    public static String createTestMethodName(String methodName) {
        return GeneratorUtils.createMethodName(methodName, JUTPreferences.getTestMethodPrefix());
    }

    public static String createMethodName(String methodName, String methodPrefix) {
        return GeneratorUtils.createMethodName(methodName, methodPrefix, true);
    }

    public static String createMethodName(String methodName, String methodPrefix, boolean concat) {
        if (concat) {
            if (methodName.length() == 0) {
                return methodPrefix;
            }
            if (methodPrefix.length() == 0) {
                return methodName;
            }
            String firstLetter = String.valueOf(methodName.charAt(0)).toUpperCase();
            String restMethodName = methodName.substring(1);
            methodName = String.valueOf(methodPrefix) + firstLetter + restMethodName;
        } else {
            methodName = methodName.replaceFirst(methodPrefix, "");
            String firstLetter = String.valueOf(methodName.charAt(0)).toLowerCase();
            String restMethodName = methodName.substring(1);
            methodName = String.valueOf(firstLetter) + restMethodName;
        }
        return methodName;
    }

    public static String createMethodNameFromTest(String testMethodName) {
        return GeneratorUtils.createMethodName(testMethodName, JUTPreferences.getTestMethodPrefix(), false);
    }

    public static String createTestClassName(String className) {
        if (className.length() == 0) {
            return "";
        }
        String firstLetter = String.valueOf(className.charAt(0)).toUpperCase();
        String restClassName = className.substring(1);
        String testClassPostfix = JUTPreferences.getTestClassPostfix();
        if (testClassPostfix == null) {
            testClassPostfix = "";
        }
        return String.valueOf(firstLetter) + restClassName + testClassPostfix;
    }

    public static String firstCharToUpper(String value) {
        if (value != null && value.length() > 0) {
            return String.valueOf(Character.toUpperCase(value.charAt(0))) + value.substring(1);
        }
        return value;
    }

    public static String firstCharToLower(String value) {
        if (value != null && value.length() > 0) {
            return String.valueOf(Character.toLowerCase(value.charAt(0))) + value.substring(1);
        }
        return value;
    }

    public static boolean compareMethods(IMethod method, Method tmlMethod) {
        if (tmlMethod == null) {
            return method == null;
        }
        if (tmlMethod.getName() == null) {
            return false;
        }
        if (tmlMethod.getName().equals(method.getElementName())) {
            ILocalVariable[] parameters;
            List<Param> tmlParams = tmlMethod.getParam();
            try {
                parameters = method.getParameters();
            }
            catch (JavaModelException e) {
                throw new RuntimeException(e);
            }
            if (tmlParams.size() == parameters.length) {
                int i = 0;
                while (i < tmlParams.size()) {
                    String paramType = Signature.getSignatureSimpleName((String)parameters[i].getTypeSignature());
                    if (!tmlParams.get(i).getType().equals(paramType)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static String createAnnoGenerated() {
        return "@Generated(value=\"org.junit-tools-1.0.1\")\n";
    }

    public static String createAnnoMethodRef(IMethod method) throws JavaModelException {
        return GeneratorUtils.createAnnoMethodRef(method.getElementName(), method.getSignature());
    }

    public static String createAnnoMethodRef(String methodName, String methodSignature) {
        return "@MethodRef(name=\"" + methodName + "\", signature=\"" + methodSignature + "\")";
    }

    public static HashMap<MethodRef, IMethod> getExistingTestMethods(ICompilationUnit cuBase, ICompilationUnit cu) throws JavaModelException {
        return GeneratorUtils.getExistingTestMethods(cuBase, cu, false);
    }

    public static HashMap<MethodRef, IMethod> getExistingTestMethods(ICompilationUnit cu) throws JavaModelException {
        return GeneratorUtils.getExistingTestMethods(null, cu, false);
    }

    public static HashMap<MethodRef, IMethod> getExistingTestMethods(ICompilationUnit cuBase, ICompilationUnit cuWithRef, boolean withByName) throws JavaModelException {
        IMethod[] methods;
        HashMap<MethodRef, IMethod> existingMethods = new HashMap<MethodRef, IMethod>();
        if (cuWithRef == null) {
            return existingMethods;
        }
        IType primaryType = cuWithRef.findPrimaryType();
        if (primaryType == null) {
            return existingMethods;
        }
        IMethod[] iMethodArray = methods = primaryType.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            MethodRef mr = GeneratorUtils.getMethodRef(method);
            if (mr != null) {
                existingMethods.put(mr, method);
            } else if (withByName && method.getElementName().startsWith(JUTPreferences.getTestMethodPrefix())) {
                String baseMethodName = GeneratorUtils.createMethodNameFromTest(method.getElementName());
                List<IMethod> baseMethods = JDTUtils.getMethods((IJavaElement)cuBase, false, baseMethodName);
                if (baseMethods.size() == 1) {
                    IMethod baseMethod = baseMethods.get(0);
                    mr = new MethodRef(baseMethod.getElementName(), baseMethod.getSignature());
                    mr.setSignatureNew(baseMethod.getSignature());
                    existingMethods.put(mr, method);
                } else {
                    mr = new MethodRef(baseMethodName, "");
                    mr.setUnresolvedConflict(true);
                    existingMethods.put(mr, method);
                }
            }
            ++n2;
        }
        if (cuBase != null) {
            GeneratorUtils.checkSignatures(existingMethods, cuBase);
        }
        return existingMethods;
    }

    private static boolean matchesMethodRef(MethodRef methodRefToCheck, IType typeBase, Set<MethodRef> allMethodRefs) throws JavaModelException {
        ArrayList<IMethod> baseMethodsWithMatchingName = new ArrayList<IMethod>();
        IMethod[] iMethodArray = typeBase.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equals(methodRefToCheck.getName())) {
                if (method.getSignature().equals(methodRefToCheck.getSignature())) {
                    return true;
                }
                baseMethodsWithMatchingName.add(method);
            }
            ++n2;
        }
        if (baseMethodsWithMatchingName.size() == 0) {
            return false;
        }
        if (baseMethodsWithMatchingName.size() != 1) {
            ArrayList<IMethod> notMatchingBaseMethods = new ArrayList<IMethod>();
            for (IMethod method : baseMethodsWithMatchingName) {
                boolean found = false;
                for (MethodRef methodRefTmp : allMethodRefs) {
                    if (!GeneratorUtils.isMethodRefEqual(method, methodRefTmp)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                notMatchingBaseMethods.add(method);
            }
            if (notMatchingBaseMethods.size() == 1) {
                methodRefToCheck.setSignatureNew(((IMethod)baseMethodsWithMatchingName.get(0)).getSignature());
                return true;
            }
            methodRefToCheck.setUnresolvedConflict(true);
            return true;
        }
        methodRefToCheck.setSignatureNew(((IMethod)baseMethodsWithMatchingName.get(0)).getSignature());
        return false;
    }

    public static boolean isMethodRefEqual(IMethod method, MethodRef methodRef) throws JavaModelException {
        return method.getElementName().equals(methodRef.getName()) && method.getSignature().equals(methodRef.getSignature());
    }

    public static MethodRef getMethodRef(IMethod method) throws JavaModelException {
        if (method == null) {
            return null;
        }
        IAnnotation annotation = method.getAnnotation("MethodRef");
        if (annotation != null && annotation.exists()) {
            boolean found = false;
            String methodName = "";
            String methodSignature = "";
            IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair valuePair = iMemberValuePairArray[n2];
                String valueName = valuePair.getMemberName();
                String value = valuePair.getValue().toString();
                if ("name".equals(valueName)) {
                    methodName = value;
                    found = true;
                } else if ("signature".equals(valueName)) {
                    methodSignature = value;
                }
                ++n2;
            }
            if (found) {
                MethodRef methodRef = new MethodRef(methodName, methodSignature);
                return methodRef;
            }
        }
        return null;
    }

    public static List<IMethod> getMethodsToCreate(HashMap<MethodRef, IMethod> existingMethods, Vector<IMethod> checkedMethods) throws JavaModelException {
        ArrayList<IMethod> methodsToCreate = new ArrayList<IMethod>();
        if (existingMethods == null || existingMethods.size() == 0) {
            return checkedMethods;
        }
        for (IMethod checkedMethod : checkedMethods) {
            boolean found = false;
            for (MethodRef methodRef : existingMethods.keySet()) {
                if (!methodRef.getName().equals(checkedMethod.getElementName()) || !methodRef.getSignatureToCompare().equals(checkedMethod.getSignature())) continue;
                found = true;
                break;
            }
            if (found) continue;
            methodsToCreate.add(checkedMethod);
        }
        return methodsToCreate;
    }

    public static String createRandomValue(String type, boolean formatValue) {
        String value = JDTUtils.isString(type) || JDTUtils.isChar(type) ? "A" : (JDTUtils.isByte(type) ? "A" : (JDTUtils.isBoolean(type) ? "false" : (JDTUtils.isNumber(type) ? (JDTUtils.isDouble(type) ? "100.0" : "1") : "null")));
        if (formatValue) {
            value = JDTUtils.formatValue(value, type);
        }
        return value;
    }

    public static List<String> createCombination(String type) {
        String initValue = JDTUtils.createInitValue(type);
        return GeneratorUtils.createCombination(type, initValue);
    }

    public static List<String> createCombination(String type, String initValue) {
        ArrayList<String> combs = new ArrayList<String>();
        combs.add(initValue);
        if (JDTUtils.isString(type) || JDTUtils.isChar(type)) {
            combs.add("null");
            combs.add("abc");
        } else if (JDTUtils.isByte(type)) {
            combs.add("A");
        } else if (JDTUtils.isBoolean(type)) {
            combs.add("true");
        } else if (JDTUtils.isNumber(type)) {
            if (JDTUtils.isDouble(type)) {
                double value;
                try {
                    value = Double.parseDouble(initValue);
                }
                catch (NumberFormatException numberFormatException) {
                    value = 0.0;
                }
                combs.add(Double.toString(value - 1.0));
                combs.add(Double.toString(value + 1.0));
            } else {
                int value;
                try {
                    value = Integer.parseInt(initValue);
                }
                catch (NumberFormatException numberFormatException) {
                    value = 0;
                }
                combs.add(Integer.toString(value - 1));
                combs.add(Integer.toString(value + 1));
            }
        }
        int i = 0;
        while (i < combs.size()) {
            String value = (String)combs.get(i);
            combs.set(i, JDTUtils.formatValue(value, type));
            ++i;
        }
        return combs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkMethodReference(String baseMethodName, String baseMethodSignature, IMethod methodToCheck) throws JavaModelException {
        IAnnotation anno = methodToCheck.getAnnotation("MethodRef");
        if (anno == null || !anno.exists()) {
            return false;
        }
        IMemberValuePair[] valuePair = anno.getMemberValuePairs();
        boolean signatureFound = false;
        boolean nameFound = false;
        IMemberValuePair[] iMemberValuePairArray = valuePair;
        int n = valuePair.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair vP = iMemberValuePairArray[n2];
            Object o = vP.getValue();
            if (o != null) {
                String methodRefValue = o.toString();
                if ("signature".equals(vP.getMemberName())) {
                    if (!methodRefValue.equals(baseMethodSignature)) return false;
                    signatureFound = true;
                } else if ("name".equals(vP.getMemberName())) {
                    if (!methodRefValue.equals(baseMethodName)) return false;
                    nameFound = true;
                }
            }
            ++n2;
        }
        return signatureFound && nameFound;
    }

    public static boolean checkMethodReferenceAndName(String baseMethodName, String baseMethodSignature, String nameToCheck, IMethod methodToCheck) throws JavaModelException {
        if (GeneratorUtils.checkMethodReference(baseMethodName, baseMethodSignature, methodToCheck)) {
            return true;
        }
        return nameToCheck != null && nameToCheck.equals(methodToCheck.getElementName());
    }

    public static void checkSignatures(HashMap<MethodRef, IMethod> existingMethods, ICompilationUnit cuBase) throws JavaModelException {
        IType typeBase = cuBase.findPrimaryType();
        for (Map.Entry<MethodRef, IMethod> entry : existingMethods.entrySet()) {
            if (!GeneratorUtils.matchesMethodRef(entry.getKey(), typeBase, existingMethods.keySet())) continue;
        }
    }

    public static IMethod findMethod(Collection<IMethod> methods, MethodRef methodRef) throws JavaModelException {
        for (IMethod method : methods) {
            boolean nameMatched = false;
            if (methodRef.getName().equals(method.getElementName())) {
                if (methodRef.getSignature().equals(method.getSignature())) {
                    return method;
                }
                nameMatched = true;
            }
            MethodRef methodRefTarget = GeneratorUtils.getMethodRef(method);
            String baseMethodName = GeneratorUtils.createMethodNameFromTest(methodRef.getName());
            if (methodRefTarget != null && methodRefTarget.getName().equals(baseMethodName) && methodRefTarget.getSignatureToCompare().equals(methodRef.getSignatureToCompare())) {
                return method;
            }
            if (!nameMatched || !JDTUtils.isMethodNameUnique(method)) continue;
            return method;
        }
        return null;
    }

    public static IMethod findMethod(Collection<MethodRef> methodRefs, IMethod method) throws JavaModelException {
        for (MethodRef methodRef : methodRefs) {
            if (!methodRef.getName().equals(method.getElementName()) || !methodRef.getSignature().equals(method.getSignature())) continue;
            return method;
        }
        return null;
    }

    public static List<IMethod> getMethodsToDelete(HashMap<MethodRef, IMethod> existingMethods, Vector<IMethod> checkedMethods) throws JavaModelException {
        ArrayList<IMethod> methodsToDelete = new ArrayList<IMethod>();
        if (existingMethods == null) {
            return methodsToDelete;
        }
        for (Map.Entry<MethodRef, IMethod> method : existingMethods.entrySet()) {
            boolean found = false;
            MethodRef methodRef = method.getKey();
            if (methodRef.isUnresolvedConflict()) continue;
            for (IMethod checkedMethod : checkedMethods) {
                if (!methodRef.isEquals(checkedMethod)) continue;
                found = true;
                break;
            }
            if (found) continue;
            methodsToDelete.add(method.getValue());
        }
        return methodsToDelete;
    }

    public static Method getClosestMethod(IMethod method, List<Method> tmlMethods) {
        Method tmlMethodTmp = null;
        for (Method tmlMethod : tmlMethods) {
            if (!GeneratorUtils.compareMethods(method, tmlMethod)) continue;
            if (JDTUtils.isMethodModifierEqual(method, tmlMethod.getModifier())) {
                return tmlMethod;
            }
            tmlMethodTmp = tmlMethod;
        }
        return tmlMethodTmp;
    }
}

