/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.generator.model.tml;

import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jdt.core.IJavaProject;
import org.junit.tools.base.JUTException;
import org.junit.tools.generator.model.tml.Test;
import org.junit.tools.generator.utils.JDTUtils;
import org.junit.tools.preferences.JUTPreferences;

public class TMLProcessor {
    private IFile tmlFile;
    private String testPackageName;
    private String testClassName;
    private IJavaProject testProject;

    public TMLProcessor(IJavaProject testProject, String testPackageName, String testClassName) {
        this.testProject = testProject;
        this.testPackageName = testPackageName;
        this.testClassName = testClassName;
        if (testProject == null) {
            return;
        }
        this.initializeTMLFile(testProject);
    }

    public void setTestProject(IJavaProject testProject) {
        if (testProject == null && testProject != this.testProject) {
            this.testProject = testProject;
            this.initializeTMLFile(testProject);
        }
    }

    private void initializeTMLFile(IJavaProject testProject) {
        String tmlContainerName = JUTPreferences.getTmlContainer();
        IFolder tmlContainer = JDTUtils.createFolder(testProject, tmlContainerName);
        if (!tmlContainer.exists()) {
            throw new RuntimeException("TML-container not found!");
        }
        this.tmlFile = tmlContainer.getFile(String.valueOf(this.testPackageName.replace(".", "_")) + "_" + this.testClassName + ".tml");
    }

    public Test readTmlFile() throws JUTException {
        if (this.tmlFile == null || !this.tmlFile.exists()) {
            return null;
        }
        Test test = null;
        try {
            this.tmlFile.refreshLocal(0, null);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Test.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            test = (Test)unmarshaller.unmarshal(this.tmlFile.getContents());
        }
        catch (Exception e) {
            throw new JUTException(e);
        }
        return test;
    }

    public void writeTmlFile(Test test) throws Exception {
        if (this.tmlFile == null) {
            throw new JUTException("TML-file is not initialized!");
        }
        if (!this.tmlFile.exists()) {
            byte[] bytes = "".getBytes();
            ByteArrayInputStream source = new ByteArrayInputStream(bytes);
            this.tmlFile.create((InputStream)source, 0, null);
            ((InputStream)source).close();
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Test.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        FileWriter fileWriter = new FileWriter(this.tmlFile.getRawLocation().makeAbsolute().toFile());
        marshaller.marshal((Object)test, (Writer)fileWriter);
        fileWriter.flush();
        fileWriter.close();
        this.tmlFile.refreshLocal(0, null);
    }
}

