/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.generator.model;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.junit.tools.base.JUTWarning;
import org.junit.tools.generator.utils.JDTUtils;
import org.junit.tools.messages.Messages;
import org.junit.tools.preferences.JUTPreferences;

public class JUTElements {
    private JUTProjects projects;
    private JUTClassesAndPackages classesAndPackages;
    private JUTConstructorsAndMethods constructorsAndMethods;

    public JUTProjects getProjects() {
        return this.projects;
    }

    public void setProjects(JUTProjects projects) throws JUTWarning {
        if (projects.isBaseProjectSelected()) {
            if (projects.getBaseProject() == null) {
                throw new JUTWarning(Messages.General_warning_project_initialization);
            }
            if (projects.getTestProject() == null) {
                throw new JUTWarning(Messages.General_warning_test_project_not_found);
            }
        } else {
            if (projects.getTestProject() == null) {
                throw new JUTWarning(Messages.General_warning_project_initialization);
            }
            if (projects.getBaseProject() == null) {
                throw new JUTWarning(Messages.General_warning_base_project_not_found);
            }
        }
        this.projects = projects;
    }

    public JUTClassesAndPackages getClassesAndPackages() {
        return this.classesAndPackages;
    }

    public void setClassesAndPackages(JUTClassesAndPackages classesAndPackages) {
        this.classesAndPackages = classesAndPackages;
    }

    public JUTConstructorsAndMethods getConstructorsAndMethods() {
        return this.constructorsAndMethods;
    }

    public void setConstructorsAndMethods(JUTConstructorsAndMethods constructorsAndMethods) {
        this.constructorsAndMethods = constructorsAndMethods;
    }

    public JUTProjects initProjects(IJavaProject project) throws JUTWarning {
        JUTProjects tmpProjects = new JUTProjects();
        if (project == null) {
            return null;
        }
        String projectName = project.getElementName();
        String testProjectPostfix = JUTPreferences.getTestProjectPostfix();
        JUTPreferences.getTestPackagePostfix();
        if (projectName.endsWith(testProjectPostfix)) {
            tmpProjects.setBaseProjectSelected(false);
            tmpProjects.setTestProject(project);
            int lastIx = projectName.lastIndexOf(testProjectPostfix);
            if (lastIx < 1) {
                throw new JUTWarning(Messages.General_warning_nothing_selected);
            }
            projectName = projectName.substring(0, lastIx);
            IJavaProject baseProject = JDTUtils.getProject(projectName);
            tmpProjects.setBaseProject(baseProject);
        } else {
            tmpProjects.setBaseProjectSelected(true);
            tmpProjects.setBaseProject(project);
            projectName = String.valueOf(projectName) + testProjectPostfix;
            tmpProjects.setTestProjectName(projectName);
            IJavaProject testProject = JDTUtils.getProject(projectName, false, project);
            if (testProject != null) {
                tmpProjects.setTestProject(testProject);
            }
        }
        this.setProjects(tmpProjects);
        return tmpProjects;
    }

    public JUTClassesAndPackages initClassesAndPackages(ICompilationUnit cu) throws JUTWarning, CoreException {
        Vector<ICompilationUnit> cuList = new Vector<ICompilationUnit>();
        cuList.add(cu);
        return this.initClassesAndPackages(cuList);
    }

    public JUTClassesAndPackages initClassesAndPackages(Vector<ICompilationUnit> cuList) throws JUTWarning, CoreException {
        ICompilationUnit baseCu;
        ICompilationUnit testCu = null;
        String baseCuName = "";
        String testCuName = "";
        IPackageFragment testPackage = null;
        String testClassPostfix = JUTPreferences.getTestClassPostfix();
        if (cuList.size() == 0) {
            throw new JUTWarning(Messages.General_warning_nothing_selected);
        }
        ICompilationUnit cu = cuList.get(0);
        if (this.projects.getBaseProject() == null) {
            this.initProjects(cu.getJavaProject());
        }
        JUTClassesAndPackages jutClassesAndPackages = this.initPackages(JDTUtils.getPackage((IJavaElement)cu));
        if (this.projects.isBaseProjectSelected()) {
            baseCu = cuList.get(0);
            IPackageFragment basePackage = jutClassesAndPackages.getBasePackage();
            if (this.projects.getTestProject() != null) {
                testPackage = jutClassesAndPackages.getTestPackage();
                baseCuName = baseCu.getElementName().replace(".java", "");
                testCuName = String.valueOf(baseCuName) + testClassPostfix;
                if (testPackage != null) {
                    testCu = testPackage.getCompilationUnit(String.valueOf(testCuName) + ".java");
                }
            }
        } else {
            testCu = cuList.get(0);
            testPackage = jutClassesAndPackages.getTestPackage();
            IPackageFragment basePackage = jutClassesAndPackages.getBasePackage();
            testCuName = testCu.getElementName().replace(".java", "");
            baseCuName = testCu.getElementName().replace(String.valueOf(testClassPostfix) + ".java", "");
            baseCu = basePackage.getCompilationUnit(String.valueOf(baseCuName) + ".java");
        }
        jutClassesAndPackages.setBaseTest(baseCu);
        jutClassesAndPackages.setBaseClassName(baseCuName);
        jutClassesAndPackages.setTestClass(testCu);
        jutClassesAndPackages.setTestClassName(testCuName);
        return jutClassesAndPackages;
    }

    public static JUTElements initJUTElements(IJavaProject project) throws JUTWarning {
        JUTElements jutElements = new JUTElements();
        jutElements.initProjects(project);
        return jutElements;
    }

    public static JUTElements initJUTElements(IJavaProject project, ICompilationUnit cu) throws JUTWarning, CoreException {
        JUTElements jutElements = new JUTElements();
        jutElements.initProjects(project);
        jutElements.initClassesAndPackages(cu);
        return jutElements;
    }

    public static JUTElements initJUTElements(IJavaProject project, IPackageFragment pack) throws JUTWarning, CoreException {
        JUTElements jutElements = new JUTElements();
        jutElements.initProjects(project);
        jutElements.initPackages(pack);
        return jutElements;
    }

    private JUTClassesAndPackages initPackages(IPackageFragment pack) throws CoreException {
        IPackageFragment basePackage;
        JUTClassesAndPackages jutClassesAndPackages = new JUTClassesAndPackages();
        IPackageFragment testPackage = null;
        String testPackagePostfix = JUTPreferences.getTestPackagePostfix();
        String baseProjectName = "";
        String basePackageName = "";
        String testProjectName = "";
        String testPackageName = "";
        if (this.projects.isBaseProjectSelected()) {
            baseProjectName = this.projects.getBaseProject().getElementName();
            basePackage = pack;
            basePackageName = pack.getElementName();
            testProjectName = null;
            if (this.projects.getTestProject() != null) {
                testProjectName = this.projects.getTestProject().getElementName();
                testPackageName = "".equals(basePackageName) ? testPackagePostfix : (basePackageName.startsWith(baseProjectName) ? basePackageName.replace(baseProjectName, testProjectName) : String.valueOf(basePackageName) + "." + testPackagePostfix);
                testPackageName = basePackageName;
                testPackage = JDTUtils.getPackage(this.projects.getTestProject(), testPackageName, false);
            }
        } else {
            testPackage = pack;
            baseProjectName = this.projects.getBaseProject().getElementName();
            testProjectName = this.projects.getTestProject().getElementName();
            basePackageName = testPackageName = testPackage.getElementName();
            basePackage = JDTUtils.getPackage(this.projects.getBaseProject(), basePackageName, false);
            if (basePackage == null || !basePackage.exists()) {
                basePackageName = testPackagePostfix.equals(testPackageName) ? "" : (testPackageName.startsWith(testProjectName) ? testPackageName.replace(testProjectName, baseProjectName) : testPackageName.replace("." + testPackagePostfix, ""));
                basePackage = JDTUtils.getPackage(this.projects.getBaseProject(), basePackageName, false);
            }
        }
        jutClassesAndPackages.setTestPackageName(testPackageName);
        jutClassesAndPackages.setBasePackage(basePackage);
        jutClassesAndPackages.setTestPackage(testPackage);
        this.setClassesAndPackages(jutClassesAndPackages);
        return jutClassesAndPackages;
    }

    public class JUTClassesAndPackages {
        private ICompilationUnit baseClass = null;
        private String testBaseName = "";
        private ICompilationUnit testClass = null;
        private String testClassName = "";
        private IPackageFragment basePackage = null;
        private IPackageFragment testPackage = null;
        private String testPackageName = null;

        public ICompilationUnit getBaseClass() {
            return this.baseClass;
        }

        public void setBaseTest(ICompilationUnit baseClass) {
            this.baseClass = baseClass;
        }

        public ICompilationUnit getTestClass() {
            return this.testClass;
        }

        public ICompilationUnit getTestClass(boolean createIfNotExists) throws CoreException {
            if (createIfNotExists && (this.testClass == null || !this.testClass.exists())) {
                IPackageFragment testPckg = this.getTestPackage(true);
                this.testClass = testPckg.createCompilationUnit(String.valueOf(this.testClassName) + ".java", "", true, null);
            }
            return this.testClass;
        }

        public void setTestClass(ICompilationUnit testClass) {
            this.testClass = testClass;
        }

        public IPackageFragment getBasePackage() {
            return this.basePackage;
        }

        public void setBasePackage(IPackageFragment basePackage) {
            this.basePackage = basePackage;
        }

        public IPackageFragment getTestPackage() {
            return this.testPackage;
        }

        public IPackageFragment getTestPackage(boolean createIfNotExists) throws CoreException {
            if (createIfNotExists && (this.testPackage == null || !this.testPackage.exists())) {
                this.testPackage = JDTUtils.createPackage(JUTElements.this.projects.getTestProject(), this.testPackageName);
            }
            return this.testPackage;
        }

        public void setTestPackage(IPackageFragment testPackage) {
            this.testPackage = testPackage;
        }

        public String getTestClassName() {
            return this.testClassName;
        }

        public void setTestClassName(String testClassName) {
            this.testClassName = testClassName;
        }

        public String getBaseClassName() {
            return this.testBaseName;
        }

        public void setBaseClassName(String baseClassName) {
            this.testBaseName = baseClassName;
        }

        public void setTestPackageName(String testPackageName) {
            this.testPackageName = testPackageName;
        }

        public String getTestPackageName() {
            return this.testPackageName;
        }
    }

    public static class JUTConstructorsAndMethods {
        private Vector<IMethod> baseClassMethods;
        private Vector<IMethod> baseClassConstructors;
        private IMethod selectedMethod;

        public Vector<IMethod> getBaseClassMethods() {
            return this.baseClassMethods;
        }

        public void setBaseClassMethods(Vector<IMethod> baseClassMethods) {
            this.baseClassMethods = baseClassMethods;
        }

        public Vector<IMethod> getBaseClassConstructors() {
            return this.baseClassConstructors;
        }

        public void setBaseClassConstructors(Vector<IMethod> baseClassConstructors) {
            this.baseClassConstructors = baseClassConstructors;
        }

        public IMethod getSelectedMethod() {
            return this.selectedMethod;
        }

        public void setSelectedMethod(IMethod selectedMethod) {
            this.selectedMethod = selectedMethod;
        }
    }

    public static class JUTProjects {
        private IJavaProject testProject = null;
        private IJavaProject baseProject = null;
        private String testProjectName = "";
        private boolean isBaseProjectSelected = true;

        public IJavaProject getTestProject() {
            return this.testProject;
        }

        public void setTestProject(IJavaProject testProject) {
            this.testProject = testProject;
        }

        public IJavaProject getBaseProject() {
            return this.baseProject;
        }

        public void setBaseProject(IJavaProject baseProject) {
            this.baseProject = baseProject;
        }

        public boolean isBaseProjectSelected() {
            return this.isBaseProjectSelected;
        }

        public void setBaseProjectSelected(boolean isBaseProjectSelected) {
            this.isBaseProjectSelected = isBaseProjectSelected;
        }

        public String getTestProjectName() {
            return this.testProjectName;
        }

        public void setTestProjectName(String testProjectName) {
            this.testProjectName = testProjectName;
        }

        public boolean isTestProjectFound() {
            return this.getTestProject() != null;
        }
    }
}

