/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.generator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.junit.tools.generator.ITestSuitesGenerator;
import org.junit.tools.generator.model.JUTElements;
import org.junit.tools.generator.utils.JDTUtils;

public class TestSuitesGenerator
implements ITestSuitesGenerator {
    private static final String TESTSUITE_PREFIX = "TestSuite";
    private ArrayList<ICompilationUnit> generatedTestSuites = new ArrayList();

    @Override
    public boolean generateTestSuites(JUTElements utmElements) throws CoreException {
        this.init();
        IJavaProject testProject = utmElements.getProjects().getTestProject();
        IPackageFragment testPackage = utmElements.getClassesAndPackages().getTestPackage(true);
        String testClassName = utmElements.getClassesAndPackages().getTestClassName();
        HashSet<String> childTestSuites = new HashSet<String>();
        boolean testSuiteExists = this.generateTestSuites(testProject, testPackage, testClassName, childTestSuites);
        if (testSuiteExists) {
            return true;
        }
        IJavaElement parent = testPackage.getParent();
        if (parent instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)parent;
            Path parentPackage = new Path(testPackage.getElementName().replace(".", "/"));
            if ("test".equals(parentPackage.lastSegment())) {
                parentPackage = parentPackage.removeLastSegments(2);
                while (parentPackage != null && !parentPackage.isEmpty() && !parentPackage.isRoot()) {
                    parentPackage = parentPackage.append("test");
                    testPackage = packageRoot.getPackageFragment(parentPackage.toString().replace("/", "."));
                    this.generateTestSuites(testProject, testPackage, null, childTestSuites);
                    parentPackage = parentPackage.removeLastSegments(2);
                }
            } else {
                parentPackage = parentPackage.removeLastSegments(1);
                while (parentPackage != null && !parentPackage.isEmpty() && !parentPackage.isRoot()) {
                    testPackage = packageRoot.getPackageFragment(parentPackage.toString().replace("/", "."));
                    this.generateTestSuites(testProject, testPackage, null, childTestSuites);
                    parentPackage = parentPackage.removeLastSegments(1);
                }
            }
            if (parentPackage.isEmpty() && (parentPackage = parentPackage.append("base").append("test")) != null) {
                testPackage = packageRoot.getPackageFragment(parentPackage.toString().replace("/", "."));
                this.generateTestSuites(testProject, testPackage, null, childTestSuites);
            }
        }
        return false;
    }

    private HashSet<String> createRootTestSuiteNameList(List<TestSuiteDeclaration> tsdList) {
        HashSet<String> rootTestSuiteNameList = new HashSet<String>();
        for (TestSuiteDeclaration tsd : tsdList) {
            rootTestSuiteNameList.add(String.valueOf(tsd.getPackageName()) + "." + tsd.getName() + ".class");
        }
        return rootTestSuiteNameList;
    }

    @Override
    public boolean generateTestSuites(final IJavaProject testProject) throws OperationCanceledException, CoreException {
        this.init();
        JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ArrayList<TestSuiteDeclaration> testSuiteDeclarations = new ArrayList<TestSuiteDeclaration>();
                TestSuiteDeclaration tsdBefore = null;
                String packageBefore = "";
                IPackageFragment baseTestSuitePackage = null;
                ICompilationUnit[] baseTestSuiteCuList = null;
                IPackageFragment[] iPackageFragmentArray = testProject.getPackageFragments();
                int n = iPackageFragmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment pf = iPackageFragmentArray[n2];
                    if (pf.getKind() == 1) {
                        if (pf.getElementName().endsWith(".testbase")) {
                            baseTestSuitePackage = pf;
                            baseTestSuiteCuList = pf.getCompilationUnits();
                        } else if (pf.getCompilationUnits().length != 0) {
                            TestSuiteDeclaration tsdTmp = new TestSuiteDeclaration();
                            tsdTmp.setName(TestSuitesGenerator.TESTSUITE_PREFIX);
                            tsdTmp.setPackageFragment(pf);
                            tsdTmp.setCuList(pf.getCompilationUnits());
                            if (tsdBefore == null || "".equals(packageBefore)) {
                                testSuiteDeclarations.add(tsdTmp);
                            } else if (JDTUtils.isParentPackage(packageBefore, pf.getElementName())) {
                                tsdTmp.setParent(tsdBefore);
                                tsdBefore.getChildTestSuiteDeclarations().add(tsdTmp);
                            } else if (tsdBefore.getParent() != null && JDTUtils.isParentPackage(tsdBefore.getParent().getPackageName(), pf.getElementName())) {
                                tsdTmp.setParent(tsdBefore.getParent());
                                tsdBefore.getParent().getChildTestSuiteDeclarations().add(tsdTmp);
                            } else {
                                testSuiteDeclarations.add(tsdTmp);
                            }
                            tsdBefore = tsdTmp;
                            packageBefore = pf.getElementName();
                        }
                    }
                    ++n2;
                }
                for (TestSuiteDeclaration tsd : testSuiteDeclarations) {
                    TestSuitesGenerator.this.processTestSuiteDeclaration(tsd);
                }
                if (baseTestSuitePackage == null) {
                    baseTestSuitePackage = JDTUtils.getPackage(testProject, String.valueOf(testProject.getElementName()) + ".testbase", true);
                    baseTestSuiteCuList = new ICompilationUnit[]{};
                }
                TestSuitesGenerator.this.processTestSuiteDeclaration("TestSuiteAll", baseTestSuitePackage, baseTestSuiteCuList, TestSuitesGenerator.this.createRootTestSuiteNameList(testSuiteDeclarations));
            }
        }, null);
        return true;
    }

    private void processTestSuiteDeclaration(TestSuiteDeclaration tsd) throws OperationCanceledException, CoreException {
        IPackageFragment testSuitePackage = tsd.getPackageFragment();
        this.processTestSuiteDeclaration(tsd.getName(), testSuitePackage, tsd.getCuList(), tsd.createChildTestSuiteNameList());
        for (TestSuiteDeclaration childTsd : tsd.getChildTestSuiteDeclarations()) {
            this.processTestSuiteDeclaration(childTsd);
        }
    }

    private void processTestSuiteDeclaration(String testSuiteName, IPackageFragment testSuitePackage, ICompilationUnit[] cuList, HashSet<String> childTestSuiteNameList) throws OperationCanceledException, CoreException {
        ICompilationUnit testSuite = testSuitePackage.getCompilationUnit(String.valueOf(testSuiteName) + ".java");
        IType testSuiteFrame = this.createTestSuiteFrame(testSuiteName, testSuite, cuList, null, childTestSuiteNameList, true);
        if (testSuiteFrame == null) {
            return;
        }
        testSuite.save(null, false);
        testSuite.makeConsistent(null);
        if (testSuite.hasUnsavedChanges()) {
            testSuite.commitWorkingCopy(true, null);
        }
        this.generatedTestSuites.add(testSuite);
    }

    private boolean generateTestSuites(IJavaProject testProject, IPackageFragment testPackage, String newTestSuiteElementName, HashSet<String> childTestSuites) throws CoreException {
        boolean exists = false;
        if (testPackage == null || !testPackage.exists()) {
            return exists;
        }
        String testSuiteName = TESTSUITE_PREFIX;
        ICompilationUnit testSuite = this.getTestSuite(testPackage);
        ICompilationUnit[] testClasses = testPackage.getCompilationUnits();
        if (testClasses.length == 0 && !"base".equals(testPackage.getPath().lastSegment())) {
            return exists;
        }
        IType testSuiteFrame = this.createTestSuiteFrame(testSuiteName, testSuite, testClasses, newTestSuiteElementName, childTestSuites, false);
        if (testSuiteFrame == null) {
            return true;
        }
        testSuite.save(null, false);
        testSuite.makeConsistent(null);
        if (testSuite.hasUnsavedChanges()) {
            testSuite.commitWorkingCopy(true, null);
        }
        this.generatedTestSuites.add(testSuite);
        childTestSuites.clear();
        String testSuitePath = "";
        if (!"".equals(testPackage.getElementName())) {
            testSuitePath = String.valueOf(testPackage.getElementName()) + ".";
        }
        childTestSuites.add(String.valueOf(testSuitePath) + TESTSUITE_PREFIX + ".class");
        return exists;
    }

    protected IType createTestSuiteFrame(String testSuiteName, ICompilationUnit testSuite, ICompilationUnit[] testClasses, String newTestSuiteElementName, HashSet<String> generatedTestSuites, boolean createNew) throws JavaModelException {
        IType type = testSuite.getType(testSuiteName);
        if (type.exists() && !createNew) {
            IAnnotation[] iAnnotationArray = type.getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                if ("Suite.SuiteClasses".equals(annotation.getElementName())) {
                    IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
                    int n3 = iMemberValuePairArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemberValuePair memberValuePairs = iMemberValuePairArray[n4];
                        Object value = memberValuePairs.getValue();
                        if (value instanceof Object[]) {
                            Object[] objectArray = (Object[])value;
                            int n5 = objectArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                Object testSuiteObject = objectArray[n6];
                                String suiteClassName = testSuiteObject.toString();
                                if (suiteClassName.startsWith(TESTSUITE_PREFIX)) {
                                    generatedTestSuites.add(String.valueOf(suiteClassName) + ".class");
                                }
                                if (suiteClassName.equals(newTestSuiteElementName)) {
                                    return null;
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        String testElementList = this.createCommaSeparatedClassList(testClasses, generatedTestSuites);
        return this.refreshTestSuiteElements(testSuite, testSuiteName, testElementList);
    }

    protected String createCommaSeparatedClassList(ICompilationUnit[] testClasses, HashSet<String> generatedTestSuites) {
        return this.createCommaSeparatedClassList(testClasses, generatedTestSuites, "");
    }

    protected String createCommaSeparatedClassList(ICompilationUnit[] testClasses, HashSet<String> generatedTestSuites, String ... exceptionClasses) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        ICompilationUnit[] iCompilationUnitArray = testClasses;
        int n = testClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String testClassNameWithClassSuffix;
            String testClassName;
            ICompilationUnit testClass = iCompilationUnitArray[n2];
            if (testClass.exists() && !(testClassName = (testClassNameWithClassSuffix = testClass.getElementName().replace(".java", ".class")).replace(".class", "")).equals(TESTSUITE_PREFIX) && testClassName.endsWith("Test") && !this.isExceptionClass(testClassName, exceptionClasses)) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(testClassNameWithClassSuffix);
            }
            ++n2;
        }
        if (generatedTestSuites != null) {
            for (String generatedTestSuite : generatedTestSuites) {
                if (generatedTestSuite.startsWith(".")) continue;
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(generatedTestSuite);
            }
        }
        return sb.toString();
    }

    private boolean isExceptionClass(String testClassName, String[] exceptionClasses) {
        String[] stringArray = exceptionClasses;
        int n = exceptionClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String exceptionClass = stringArray[n2];
            if (exceptionClass.equals(testClassName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void init() {
        this.generatedTestSuites = new ArrayList();
    }

    @Override
    public boolean deleteTestSuiteElement(final IPackageFragment packageOfDeletedClass, final ICompilationUnit deletedClass) throws CoreException {
        this.init();
        if (packageOfDeletedClass == null) {
            return true;
        }
        JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ICompilationUnit testSuite = TestSuitesGenerator.this.getTestSuite(packageOfDeletedClass);
                String testElementList = TestSuitesGenerator.this.createCommaSeparatedClassList(packageOfDeletedClass.getCompilationUnits(), null, deletedClass.getElementName().replace(".java", ""));
                IType testSuiteType = TestSuitesGenerator.this.refreshTestSuiteElements(testSuite, TestSuitesGenerator.TESTSUITE_PREFIX, testElementList);
                if (testSuiteType == null) {
                    JDTUtils.deletePackages(packageOfDeletedClass);
                }
            }
        }, null);
        return true;
    }

    protected ICompilationUnit getTestSuite(IPackageFragment p) {
        return p.getCompilationUnit("TestSuite.java");
    }

    private IType refreshTestSuiteElements(ICompilationUnit testSuite, String testSuiteName, String testElementList) throws JavaModelException {
        IType testSuiteType = testSuite.getType(testSuiteName);
        if (testSuiteType.exists()) {
            testSuiteType.delete(true, null);
        }
        if (testElementList.length() <= 0) {
            testSuite.delete(true, null);
            return null;
        }
        String testAnnotation = "@RunWith(Suite.class)\n@Suite.SuiteClasses(\n\n{" + testElementList + "}\n)";
        testSuiteType = testSuite.createType(String.valueOf(testAnnotation) + "\npublic class " + testSuiteType.getElementName() + "{ // nothing\n}", null, true, null);
        return testSuiteType;
    }

    @Override
    public ArrayList<ICompilationUnit> getGeneratedTestSuites() {
        return this.generatedTestSuites;
    }

    private class TestSuiteDeclaration {
        private TestSuiteDeclaration parent = null;
        private String name;
        private IPackageFragment packageFragment;
        private ICompilationUnit[] cuList = null;
        private List<TestSuiteDeclaration> childTestSuiteDeclarations = new ArrayList<TestSuiteDeclaration>();

        private TestSuiteDeclaration() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPackageName() {
            return this.packageFragment.getElementName();
        }

        public ICompilationUnit[] getCuList() {
            return this.cuList;
        }

        public void setCuList(ICompilationUnit[] cuList) {
            this.cuList = cuList;
        }

        public List<TestSuiteDeclaration> getChildTestSuiteDeclarations() {
            return this.childTestSuiteDeclarations;
        }

        public TestSuiteDeclaration getParent() {
            return this.parent;
        }

        public void setParent(TestSuiteDeclaration parent) {
            this.parent = parent;
        }

        public void setPackageFragment(IPackageFragment pf) {
            this.packageFragment = pf;
        }

        public IPackageFragment getPackageFragment() {
            return this.packageFragment;
        }

        public HashSet<String> createChildTestSuiteNameList() {
            HashSet<String> childTestSuiteNameList = new HashSet<String>();
            for (TestSuiteDeclaration tsd : this.childTestSuiteDeclarations) {
                childTestSuiteNameList.add(String.valueOf(tsd.getPackageName()) + "." + tsd.getName() + ".class");
            }
            return childTestSuiteNameList;
        }
    }
}

