/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.generator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.core.Annotation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.junit.tools.base.MethodRef;
import org.junit.tools.generator.IGeneratorConstants;
import org.junit.tools.generator.ITestClassGenerator;
import org.junit.tools.generator.ITestDataFactory;
import org.junit.tools.generator.model.GeneratorModel;
import org.junit.tools.generator.model.JUTElements;
import org.junit.tools.generator.model.tml.Assertion;
import org.junit.tools.generator.model.tml.AssertionType;
import org.junit.tools.generator.model.tml.Constructor;
import org.junit.tools.generator.model.tml.Method;
import org.junit.tools.generator.model.tml.Mocks;
import org.junit.tools.generator.model.tml.Param;
import org.junit.tools.generator.model.tml.ParamAssignment;
import org.junit.tools.generator.model.tml.Result;
import org.junit.tools.generator.model.tml.Settings;
import org.junit.tools.generator.model.tml.Test;
import org.junit.tools.generator.model.tml.TestBase;
import org.junit.tools.generator.model.tml.TestBases;
import org.junit.tools.generator.model.tml.TestCase;
import org.junit.tools.generator.model.tml.Testprio;
import org.junit.tools.generator.utils.GeneratorUtils;
import org.junit.tools.generator.utils.JDTUtils;
import org.junit.tools.preferences.JUTPreferences;

public class TestClassGenerator
implements ITestClassGenerator,
IGeneratorConstants {
    protected String testmethodPrefix;
    protected String testmethodPostfix;
    protected boolean defaultTestbaseMethodCreated = false;
    private String annoGenerated = null;

    @Override
    public ICompilationUnit generate(GeneratorModel model, List<ITestDataFactory> testDataFactories, IProgressMonitor monitor) throws Exception {
        boolean writeTML = JUTPreferences.isWriteTML();
        this.defaultTestbaseMethodCreated = false;
        Test tmlTest = model.getTmlTest();
        Settings tmlSettings = tmlTest.getSettings();
        JUTElements.JUTClassesAndPackages utmClassesAndPackages = model.getJUTElements().getClassesAndPackages();
        ICompilationUnit testClass = utmClassesAndPackages.getTestClass(true);
        String testClassName = utmClassesAndPackages.getTestClassName();
        ICompilationUnit baseClass = utmClassesAndPackages.getBaseClass();
        String baseClassName = utmClassesAndPackages.getBaseClassName();
        int methodSize = tmlTest.getMethod().size();
        int increment = methodSize >= 300 ? 50 : (methodSize >= 100 ? 30 : 20);
        monitor.beginTask("", 6 + (methodSize /= increment));
        IType type = this.createTestClassFrame(testClass, tmlTest, testClassName);
        if (this.incrementTask(monitor)) {
            return null;
        }
        if (testClass.exists()) {
            this.deleteGeneratedElements(testClass, tmlSettings);
        }
        if (this.incrementTask(monitor)) {
            return null;
        }
        this.createStandardImports(testClass, tmlTest);
        if (this.incrementTask(monitor)) {
            return null;
        }
        this.createStandardClassFields(type, tmlTest, testClassName);
        if (this.incrementTask(monitor)) {
            return null;
        }
        this.createStandardMethods(type, tmlSettings);
        if (this.incrementTask(monitor)) {
            return null;
        }
        if (writeTML) {
            this.createTestBaseMethods(type, tmlTest, baseClassName);
        } else {
            this.createTestBaseMethods(type, baseClass, baseClassName, model.getJUTElements().getConstructorsAndMethods().getBaseClassConstructors(), testDataFactories);
        }
        if (this.incrementTask(monitor)) {
            return null;
        }
        for (IMethod methodToDelete : model.getMethodsToDelete()) {
            methodToDelete.delete(true, null);
        }
        if (this.createTestMethods(type, model.getMethodMap(), model.getMethodsToCreate(), tmlSettings, baseClassName, monitor, increment)) {
            return null;
        }
        this.updateExistingMethods(type.getCompilationUnit(), type, model.getExistingMethods());
        IPackageFragment testPackage = model.getJUTElements().getClassesAndPackages().getTestPackage();
        testClass.createPackageDeclaration(testPackage.getElementName(), null);
        this.createStandardStaticImports(testClass);
        testClass.save(null, true);
        testClass.makeConsistent(null);
        if (testClass.hasUnsavedChanges()) {
            testClass.commitWorkingCopy(true, null);
        }
        return testClass;
    }

    protected void updateExistingMethods(ICompilationUnit cu, IType cuType, HashMap<MethodRef, IMethod> existingMethods) throws JavaModelException, IllegalArgumentException, MalformedTreeException, BadLocationException {
        for (Map.Entry<MethodRef, IMethod> entry : existingMethods.entrySet()) {
            MethodRef methodRef = entry.getKey();
            if (!methodRef.isSignatureChanged()) continue;
            IAnnotation[] iAnnotationArray = entry.getValue().getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation iAnnotation = iAnnotationArray[n2];
                if (iAnnotation instanceof Annotation) {
                    Annotation annotation = (Annotation)iAnnotation;
                    if ("MethodRef".equals(iAnnotation.getElementName()) && annotation.exists()) {
                        annotation.delete(true, null);
                    }
                }
                ++n2;
            }
            CompilationUnit astRoot = JDTUtils.createASTRoot(cu);
            MethodDeclaration md = JDTUtils.createMethodDeclaration(astRoot, entry.getValue());
            ASTRewrite rewriter = ASTRewrite.create((AST)md.getAST());
            NormalAnnotation newNormalAnnotation = rewriter.getAST().newNormalAnnotation();
            newNormalAnnotation.setTypeName(astRoot.getAST().newName("MethodRef"));
            newNormalAnnotation.values().add(this.createAnnotationMemberValuePair(astRoot.getAST(), "name", methodRef.getName()));
            newNormalAnnotation.values().add(this.createAnnotationMemberValuePair(astRoot.getAST(), "signature", methodRef.getSignatureNew()));
            rewriter.getListRewrite((ASTNode)md, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)newNormalAnnotation, null);
            TextEdit textEdit = rewriter.rewriteAST();
            Document document = new Document(cu.getSource());
            textEdit.apply((IDocument)document);
            String newSource = document.get();
            cu.getBuffer().setContents(newSource);
        }
    }

    protected MemberValuePair createAnnotationMemberValuePair(AST ast, String name, String value) {
        MemberValuePair mvp = ast.newMemberValuePair();
        mvp.setName(ast.newSimpleName(name));
        StringLiteral stringLiteral = ast.newStringLiteral();
        stringLiteral.setLiteralValue(value);
        mvp.setValue((Expression)stringLiteral);
        return mvp;
    }

    protected void createTestBaseMethods(IType type, ICompilationUnit baseClass, String baseClassName, Vector<IMethod> constructors, List<ITestDataFactory> testDataFactories) throws JavaModelException {
        StringBuilder classCreationChain = new StringBuilder();
        String testBaseMethodName = "createTestSubject";
        if (type.getMethod(testBaseMethodName, null).exists()) {
            return;
        }
        JDTUtils.createClassCreationChain(baseClass.findPrimaryType(), classCreationChain, testDataFactories);
        String testBaseMethodBody = " return " + classCreationChain.toString() + ";";
        JDTUtils.createMethod(type, "private", baseClassName, testBaseMethodName, null, null, testBaseMethodBody, false, new String[0]);
    }

    protected void createTestBaseMethods(IType type, Test tmlTest, String testBaseName) throws JavaModelException {
        Settings tmlSettings = tmlTest.getSettings();
        TestBases tmlTestbases = tmlTest.getTestBases();
        if (tmlSettings == null || tmlTestbases == null) {
            return;
        }
        for (Constructor tmlConstructor : tmlTestbases.getConstructor()) {
            for (TestBase tmlTestbase : tmlConstructor.getTestBase()) {
                String testBaseMethodName = this.createTestBaseMethodName(tmlTestbase.getName());
                String testBaseMethodBody = this.createTestBaseMethodBody(tmlTestbase, testBaseName, testBaseMethodName, tmlConstructor.getParam(), tmlSettings);
                JDTUtils.createMethod(type, "private", testBaseName, testBaseMethodName, "Exception", null, testBaseMethodBody, false, new String[0]);
            }
            if (tmlConstructor.getTestBase().size() != 0) continue;
            this.createTestBaseMethodDefault(type, testBaseName, tmlConstructor.getParam());
        }
    }

    protected void createStandardMethods(IType type, Settings tmlSettings) throws JavaModelException {
        if (tmlSettings == null) {
            return;
        }
        if (tmlSettings.isSetUp()) {
            JDTUtils.createMethod(type, "public", "void", "setUp", "Exception", null, "", false, "@Before");
        }
        if (tmlSettings.isSetUpBeforeClass()) {
            JDTUtils.createMethod(type, "public static", "void", "setUpBeforeClass", "Exception", null, "", false, "@BeforeClass");
        }
        if (tmlSettings.isTearDown()) {
            JDTUtils.createMethod(type, "public", "void", "tearDown", "Exception", null, "", false, "@After");
        }
        if (tmlSettings.isTearDownBeforeClass()) {
            JDTUtils.createMethod(type, "public static", "void", "tearDownAfterClass", "Exception", null, "", false, "@AfterClass");
        }
    }

    protected void createHookAfterMethodCall(IType type, String hookMethodName, String param) throws JavaModelException {
        JDTUtils.createMethod(type, "private", "void", hookMethodName, "Exception", param, "", false, new String[0]);
    }

    protected boolean incrementTask(IProgressMonitor monitor) {
        return this.incrementTask(monitor, 1);
    }

    protected boolean incrementTask(IProgressMonitor monitor, int i) {
        if (monitor.isCanceled()) {
            return true;
        }
        monitor.worked(i);
        return false;
    }

    protected void deleteGeneratedElements(ICompilationUnit testClass, Settings tmlSettings) throws JavaModelException {
        IType[] types;
        IType[] iTypeArray = types = testClass.getTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            IJavaElement[] iJavaElementArray = type.getChildren();
            int n3 = iJavaElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IField field;
                IJavaElement element = iJavaElementArray[n4];
                if (element instanceof IMethod) {
                    IMethod method = (IMethod)element;
                    if (!this.deleteStandardMethod(method.getElementName().replace(".java", ""), tmlSettings)) {
                        // empty if block
                    }
                } else if (element instanceof IField && this.isGenerated((field = (IField)element).getAnnotations())) {
                    field.delete(true, null);
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected boolean deleteStandardMethod(String methodName, Settings tmlSettings) {
        if ("setUp".equals(methodName)) {
            return !tmlSettings.isSetUp();
        }
        if ("setUpBeforeClass".equals(methodName)) {
            return !tmlSettings.isSetUpBeforeClass();
        }
        if ("tearDown".equals(methodName)) {
            return !tmlSettings.isTearDown();
        }
        if ("tearDownAfterClass".equals(methodName)) {
            return !tmlSettings.isTearDownBeforeClass();
        }
        return true;
    }

    protected IType createTestClassFrame(ICompilationUnit testCompilationUnit, Test tmlTest, String testClassName) throws JavaModelException {
        IType type = testCompilationUnit.getType(testClassName);
        if (!type.exists()) {
            return this.createTestClassFrame(testCompilationUnit, tmlTest, testClassName, null);
        }
        Vector<Annotation> annotationsToDelete = this.getAnnotationsToDelete(type, tmlTest);
        if (annotationsToDelete != null) {
            for (Annotation annotation : annotationsToDelete) {
                annotation.delete(true, null);
            }
            String source = type.getSource();
            type.delete(true, null);
            return this.createTestClassFrame(testCompilationUnit, tmlTest, testClassName, source);
        }
        return type;
    }

    protected Vector<Annotation> getAnnotationsToDelete(IType type, Test tmlTest) throws JavaModelException {
        Vector<Annotation> annotationsToDelete = new Vector<Annotation>();
        boolean recreationNecessary = false;
        IAnnotation[] iAnnotationArray = type.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation iAnnotation = iAnnotationArray[n2];
            if (iAnnotation instanceof Annotation) {
                IMemberValuePair valuePair;
                int n3;
                int n4;
                IMemberValuePair[] iMemberValuePairArray;
                IMemberValuePair[] memberValuePairs;
                Annotation annotation = (Annotation)iAnnotation;
                if ("Generated".equals(iAnnotation.getElementName())) {
                    annotationsToDelete.add(annotation);
                    iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
                    n4 = memberValuePairs.length;
                    n3 = 0;
                    while (n3 < n4) {
                        valuePair = iMemberValuePairArray[n3];
                        if (!"org.junit-tools-1.0.1".equals(valuePair.getValue())) {
                            recreationNecessary = true;
                            break;
                        }
                        ++n3;
                    }
                } else if ("Testprio".equals(iAnnotation.getElementName())) {
                    annotationsToDelete.add(annotation);
                    memberValuePairs = annotation.getMemberValuePairs();
                    if (memberValuePairs.length == 0 && tmlTest.getTestPrio().compareTo(Testprio.DEFAULT) != 0) {
                        recreationNecessary = true;
                    }
                    iMemberValuePairArray = memberValuePairs;
                    n4 = memberValuePairs.length;
                    n3 = 0;
                    while (n3 < n4) {
                        valuePair = iMemberValuePairArray[n3];
                        if (!valuePair.getValue().toString().endsWith(tmlTest.getTestPrio().toString())) {
                            recreationNecessary = true;
                            break;
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        if (!recreationNecessary) {
            return null;
        }
        return annotationsToDelete;
    }

    protected IType createTestClassFrame(ICompilationUnit testCompilationUnit, Test tmlTest, String testclassName, String source) throws JavaModelException {
        String annotations = this.createTestClassFrameAnnotations(tmlTest.getTestPrio());
        String superType = "";
        if (source == null) {
            String customComment = this.getTestClassComment();
            superType = tmlTest.getSuperClass();
            String extendsStmt = "";
            if (superType != null && !"".equals(superType)) {
                extendsStmt = " extends " + superType;
            } else {
                superType = "";
            }
            source = String.valueOf(customComment) + annotations.toString() + "public" + " class " + testclassName + extendsStmt + "{ " + "\n" + "}";
        } else {
            source = String.valueOf(annotations) + source;
        }
        IType type = testCompilationUnit.createType(source, null, true, null);
        String superTypePackage = tmlTest.getSuperClassPackage();
        if (!"".equals(superType) && superTypePackage != null && !"".equals(superTypePackage)) {
            testCompilationUnit.createImport(String.valueOf(superTypePackage) + "." + superType, null, null);
        }
        return type;
    }

    protected String getTestClassComment() {
        return "";
    }

    protected String createTestClassFrameAnnotations(Testprio testprio) {
        StringBuilder annotations = new StringBuilder();
        annotations.append(this.createAnnoGenerated());
        annotations.append(this.createAnnoTestprio(testprio));
        return annotations.toString();
    }

    protected String createAnnoGenerated() {
        if (this.annoGenerated == null) {
            this.annoGenerated = GeneratorUtils.createAnnoGenerated();
        }
        return this.annoGenerated;
    }

    protected void createStandardImports(ICompilationUnit compilationUnit, Test tmlTest) throws JavaModelException {
        compilationUnit.createImport("java.util.*", null, null);
        compilationUnit.createImport("org.junit.Assert", null, null);
        compilationUnit.createImport("org.junit.Test", null, null);
        if (tmlTest.getSettings().isLogger()) {
            compilationUnit.createImport("java.util.logging.Logger", null, null);
        }
    }

    protected void createStandardStaticImports(ICompilationUnit compilationUnit) throws JavaModelException {
        IImportDeclaration importAbove = null;
        IImportDeclaration[] imports = compilationUnit.getImports();
        if (imports.length > 0) {
            importAbove = imports[0];
            compilationUnit.createImport("org.junit.Assert.*", (IJavaElement)importAbove, 8, null);
        }
    }

    protected void createStandardClassFields(IType type, Test tmlTest, String testclassName) throws JavaModelException {
        if (tmlTest.getSettings().isLogger()) {
            String logger = String.valueOf(this.createAnnoGenerated()) + " " + "private" + " Logger logger = Logger.getLogger(" + testclassName + ".class.toString());";
            type.createField(logger, null, false, null);
        }
    }

    protected void createTestBaseMethodDefault(IType type, String testbaseName, List<Param> params) throws JavaModelException {
        if (this.defaultTestbaseMethodCreated) {
            return;
        }
        String paramValueList = params != null ? this.createParamValueList(params, null) : "";
        StringBuilder sbMethodBody = new StringBuilder();
        sbMethodBody.append("return new ").append(testbaseName).append("(").append(paramValueList).append(");");
        JDTUtils.createMethod(type, "private", testbaseName, "createTestSubject", null, null, sbMethodBody.toString(), new String[0]);
        this.defaultTestbaseMethodCreated = true;
    }

    protected String createTestBaseMethodName(String tmlTestBaseName) {
        String testBaseName = GeneratorUtils.firstCharToUpper(tmlTestBaseName);
        String testBaseMethodName = "createTestSubject" + testBaseName;
        return testBaseMethodName;
    }

    protected String createTestBaseMethodBody(TestBase tmlTestbase, String testBaseName, String testBaseMethodName, List<Param> params, Settings tmlSettings) {
        StringBuilder sbMethodBody = new StringBuilder();
        String constructorParams = "";
        if (params.size() > 0) {
            constructorParams = this.createParamValueList(params, tmlTestbase.getParamValue());
        }
        String testBaseMocks = this.createTestBaseMocks(tmlTestbase.getMocks());
        String testBaseVariableName = GeneratorUtils.firstCharToLower(testBaseName);
        sbMethodBody.append(testBaseName).append(" ").append(testBaseVariableName).append("=").append("new ").append(testBaseName).append("(").append(constructorParams).append(") {").append(testBaseMocks).append("};").append("\n");
        sbMethodBody.append("return ").append(testBaseVariableName).append(";");
        return sbMethodBody.toString();
    }

    protected String createParamArrayList(List<Param> params) {
        StringBuilder sbParamArrayList = new StringBuilder();
        boolean firstInit = true;
        int i = 0;
        while (i < params.size()) {
            if (!firstInit) {
                sbParamArrayList.append(",");
            } else {
                firstInit = false;
            }
            sbParamArrayList.append("(").append(params.get(i).getType()).append(")paramList[").append(i).append("]");
            ++i;
        }
        return sbParamArrayList.toString();
    }

    protected String createParamArray(List<Param> params, List<String> paramValues) {
        StringBuilder sbParamArray = new StringBuilder();
        boolean firstInit = true;
        int i = 0;
        while (i < params.size() && i < paramValues.size()) {
            if (firstInit) {
                sbParamArray.append("Object[] paramList = new Object[").append(params.size()).append("];");
                firstInit = false;
            }
            sbParamArray.append("paramList[").append(i).append("] = ").append(JDTUtils.formatValue(paramValues.get(i), params.get(i).getType())).append(";").append("\n");
            ++i;
        }
        return sbParamArray.toString();
    }

    protected String createTestBaseMocks(Mocks mocks) {
        if (mocks == null) {
            return "";
        }
        StringBuilder sbMockMethods = new StringBuilder();
        for (Method tmlMockMethod : mocks.getMethod()) {
            String resultValue;
            String resultType;
            if (tmlMockMethod.getResult() != null) {
                resultType = tmlMockMethod.getResult().getType();
                resultValue = tmlMockMethod.getResult().getValue();
                resultValue = JDTUtils.formatValue(resultValue, resultType);
                resultValue = "return " + resultValue + ";";
            } else {
                resultType = "void";
                resultValue = "";
            }
            String modifier = tmlMockMethod.getModifier();
            if ("".equals(modifier)) {
                modifier = "";
            }
            sbMockMethods.append(modifier).append(" ").append(resultType).append(" ").append(tmlMockMethod.getName()).append("(").append(this.createParamList(tmlMockMethod.getParam())).append(") {").append(resultValue).append("}");
        }
        return sbMockMethods.toString();
    }

    protected boolean createTestMethods(IType type, HashMap<IMethod, Method> methodMap, List<IMethod> methodsToCreate, Settings tmlSettings, String baseClassName, IProgressMonitor monitor, int increment) throws JavaModelException {
        int i = 0;
        boolean failAssertions = tmlSettings.isFailAssertions();
        for (IMethod methodToCreate : methodsToCreate) {
            Method tmlMethod = methodMap.get(methodToCreate);
            this.createTestMethod(type, tmlMethod, baseClassName, failAssertions);
            if (i++ != increment) continue;
            i = 0;
            if (!this.incrementTask(monitor)) continue;
            return true;
        }
        return false;
    }

    protected void createTestMethod(IType type, Method tmlMethod, String baseClassName, boolean failAssertions) throws JavaModelException {
        String testMethodNamePrefix = this.getTestmethodPrefix();
        String testMethodNamePostfix = this.getTestmethodPostfix();
        String testMethodName = testMethodNamePrefix != null && testMethodNamePrefix.length() > 0 ? String.valueOf(testMethodNamePrefix) + GeneratorUtils.firstCharToUpper(tmlMethod.getName()) + testMethodNamePostfix : String.valueOf(tmlMethod.getName()) + testMethodNamePostfix;
        String testMethodBody = this.createTestMethodBody(type, tmlMethod, testMethodName, baseClassName, failAssertions);
        String annoMethodRef = GeneratorUtils.createAnnoMethodRef(tmlMethod.getName(), tmlMethod.getSignature());
        JDTUtils.createMethod(type, "public", "void", testMethodName, "Exception", null, testMethodBody, true, annoMethodRef, "@Test");
    }

    protected String createTestMethodBody(IType type, Method tmlMethod, String methodName, String baseClassName, boolean failAssertions) throws JavaModelException {
        StringBuilder sbTestMethodBody = new StringBuilder();
        List<Param> params = tmlMethod.getParam();
        String testbaseMethodName = "";
        String testBaseVariableName = "testSubject";
        if (!tmlMethod.isStatic().booleanValue()) {
            sbTestMethodBody.append(baseClassName).append(" ").append(testBaseVariableName).append(";");
        }
        this.createParamInitializations(params, sbTestMethodBody);
        Result result = tmlMethod.getResult();
        String resultVariableName = "";
        String resultType = "";
        if (result != null) {
            resultVariableName = result.getName();
            resultType = result.getType();
            sbTestMethodBody.append(resultType).append(" ").append(resultVariableName).append(";");
        }
        List<TestCase> testCases = tmlMethod.getTestCase();
        boolean isPublic = "public".equals(tmlMethod.getModifier());
        for (TestCase tmlTestcase : testCases) {
            sbTestMethodBody.append("\n\n// ").append(tmlTestcase.getName()).append("\n");
            testbaseMethodName = this.createTestBaseMethodName(tmlTestcase.getTestBase());
            this.createTestCaseBody(sbTestMethodBody, tmlMethod.getName(), baseClassName, testBaseVariableName, testbaseMethodName, resultVariableName, resultType, params, tmlTestcase.getParamAssignments(), isPublic, tmlMethod.isStatic());
            this.createAssertionsMethodBody(sbTestMethodBody, resultVariableName, resultType, testBaseVariableName, tmlTestcase);
        }
        if (failAssertions) {
            sbTestMethodBody.append("\n\n").append("Assert.fail();");
        }
        return sbTestMethodBody.toString();
    }

    protected void createTestCaseBody(StringBuilder sbTestMethodBody, String methodName, String baseClassName, String testBaseVariableName, String testBaseMethodName, String resultVariableName, String resultType, List<Param> params, List<ParamAssignment> paramAssignments, boolean isPublic, boolean isStatic) {
        String baseName;
        if (!isStatic) {
            baseName = testBaseVariableName;
            sbTestMethodBody.append(testBaseVariableName).append("=").append(testBaseMethodName).append("();");
        } else {
            baseName = baseClassName;
        }
        this.createParamAssignments(paramAssignments, sbTestMethodBody);
        String paramNameList = this.createParamNameList(params);
        if (resultVariableName.length() > 0) {
            sbTestMethodBody.append(resultVariableName).append("=");
        }
        if (isPublic) {
            sbTestMethodBody.append(baseName).append(".").append(methodName).append("(").append(paramNameList).append(");");
        } else {
            if (paramNameList.length() > 0) {
                paramNameList = ", new Object[]{" + paramNameList + "}";
            }
            if (isStatic) {
                baseName = String.valueOf(baseName) + ".class";
            }
            sbTestMethodBody.append("Deencapsulation.invoke(").append(baseName).append(", ").append("\"").append(methodName).append("\"").append(paramNameList).append(");");
        }
    }

    protected String createParamNameList(List<Param> params) {
        StringBuilder sbParamList = new StringBuilder();
        String comma = "";
        for (Param param : params) {
            sbParamList.append(comma);
            sbParamList.append(param.getName());
            comma = ", ";
        }
        return sbParamList.toString();
    }

    protected void createParamInitializations(List<Param> params, StringBuilder methodBody) {
        for (Param param : params) {
            methodBody.append(param.getType()).append(" ").append(param.getName()).append(" = ").append(JDTUtils.createInitValue(param.getType(), true)).append(";").append("\n");
        }
    }

    protected void createParamAssignments(List<ParamAssignment> paramAssignments, StringBuilder methodBody) {
        for (ParamAssignment pa : paramAssignments) {
            methodBody.append(pa.getParamName()).append(" = ").append(pa.getAssignment()).append(";\n");
        }
    }

    protected void createAssertionsMethodBody(StringBuilder sbTestMethodBody, String resultVariableName, String resultType, String testBaseVariableName, TestCase tmlTestCase) {
        for (Assertion tmlAssertion : tmlTestCase.getAssertion()) {
            String baseType;
            String base;
            if ("{result}".equals(tmlAssertion.getBase())) {
                if ("".equals(resultVariableName)) continue;
                base = "result";
                baseType = resultType;
            } else {
                base = String.valueOf(testBaseVariableName) + "." + tmlAssertion.getBase() + "()";
                baseType = tmlAssertion.getBaseType();
            }
            AssertionType type = tmlAssertion.getType();
            String assertionType = this.createAssertionType(type, baseType);
            sbTestMethodBody.append("\nAssert.").append(assertionType).append("(");
            String message = "";
            if (tmlAssertion.getMessage() != null && tmlAssertion.getMessage().length() > 0) {
                message = String.valueOf(tmlTestCase.getName()) + ": " + tmlAssertion.getMessage();
                sbTestMethodBody.append("\"").append(message).append("\"").append(", ");
            }
            if (type == AssertionType.EQUALS || type == AssertionType.NOT_EQUALS) {
                String testValue = tmlAssertion.getValue();
                testValue = JDTUtils.formatValue(testValue, baseType);
                sbTestMethodBody.append(testValue).append(", ");
                sbTestMethodBody.append(base);
                if (JDTUtils.isNumber(baseType) && !JDTUtils.isArray(baseType)) {
                    sbTestMethodBody.append(", 0");
                }
            } else {
                sbTestMethodBody.append(base);
            }
            sbTestMethodBody.append(");");
        }
    }

    protected String createAssertionType(AssertionType type, String baseType) {
        String assertionType = "assertEquals";
        if (type == AssertionType.EQUALS) {
            assertionType = JDTUtils.isArray(baseType) ? "assertArrayEquals" : "assertEquals";
        } else if (type == AssertionType.NOT_EQUALS) {
            assertionType = "assertNotEquals";
        } else if (type == AssertionType.IS_NULL) {
            assertionType = "assertNull";
        } else if (type == AssertionType.NOT_NULL) {
            assertionType = "assertNotNull";
        } else if (type == AssertionType.IS_TRUE) {
            assertionType = "assertTrue";
        } else if (type == AssertionType.IS_FALSE) {
            assertionType = "assertFalse";
        }
        return assertionType;
    }

    protected String createParamList(List<Param> params) {
        StringBuilder sbParamList = new StringBuilder();
        boolean firstInit = true;
        int i = 0;
        while (i < params.size()) {
            if (!firstInit) {
                sbParamList.append(", ");
            } else {
                firstInit = false;
            }
            Param tmlParam = params.get(i);
            sbParamList.append(tmlParam.getType()).append(" ").append(tmlParam.getName());
            ++i;
        }
        return sbParamList.toString();
    }

    protected String createParamValueList(List<Param> params, List<String> paramValues) {
        StringBuilder sbParamList = new StringBuilder();
        boolean firstInit = true;
        int i = 0;
        while (i < params.size() && (paramValues == null || i < paramValues.size())) {
            if (!firstInit) {
                sbParamList.append(", ");
            } else {
                firstInit = false;
            }
            Param tmlParam = params.get(i);
            String type = tmlParam.getType();
            String value = paramValues != null ? paramValues.get(i) : "";
            value = JDTUtils.formatValue(value, type);
            sbParamList.append(value);
            ++i;
        }
        return sbParamList.toString();
    }

    protected String getTestmethodPrefix() {
        if (this.testmethodPrefix == null) {
            this.testmethodPrefix = JUTPreferences.getTestMethodPrefix();
        }
        return this.testmethodPrefix;
    }

    protected String getTestmethodPostfix() {
        if (this.testmethodPostfix == null) {
            this.testmethodPostfix = JUTPreferences.getTestMethodPostfix();
        }
        return this.testmethodPostfix;
    }

    protected String createAnnoTestprio(Testprio testprio) {
        if (testprio == Testprio.DEFAULT) {
            return "@Testprio\n";
        }
        return "@Testprio(prio=org.junit.tools.generator.model.tml.Testprio." + (Object)((Object)testprio) + ")" + "\n";
    }

    protected boolean isGenerated(IAnnotation[] annotations) {
        IAnnotation[] iAnnotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            if ("Generated".equals(annotation.getElementName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

