/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.junit.tools.generator.model.GeneratorModel;
import org.junit.tools.generator.model.tml.Assertion;
import org.junit.tools.generator.model.tml.AssertionType;
import org.junit.tools.generator.model.tml.Method;
import org.junit.tools.generator.model.tml.ObjectFactory;
import org.junit.tools.generator.model.tml.Param;
import org.junit.tools.generator.model.tml.ParamAssignment;
import org.junit.tools.generator.model.tml.TestCase;
import org.junit.tools.generator.utils.GeneratorUtils;
import org.junit.tools.generator.utils.JDTUtils;

public class TestCasesGenerator {
    private static final ArrayList<TestCase> EMPTY_LIST_TC = new ArrayList();
    private final ObjectFactory of = new ObjectFactory();

    private void analyzeBaseMethod(IMethod method, Method tmlMethod) throws IllegalArgumentException, JavaModelException {
        CompilationUnit cu = JDTUtils.createASTRoot(method.getCompilationUnit());
        MethodDeclaration md = JDTUtils.createMethodDeclaration(cu, method);
        Block body = md.getBody();
        if (body != null) {
            for (Object statement : body.statements()) {
                if (!(statement instanceof Statement)) continue;
                Statement st = (Statement)statement;
                this.processIfStatements(st, tmlMethod);
            }
        }
    }

    private TestCase createTestCase() {
        TestCase tc = this.of.createTestCase();
        tc.setName("test");
        tc.setTestBase("");
        return tc;
    }

    private List<TestCase> createTestcaseForCheck(Param param, String value) {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>(2);
        TestCase tc = this.createTestCase();
        ParamAssignment pa = this.of.createParamAssignment();
        pa.setParamName(param.getName());
        pa.setAssignment(value);
        tc.getParamAssignments().add(pa);
        testCases.add(tc);
        String initValue = JDTUtils.createInitValue(param.getType(), true);
        if (initValue.equals(value)) {
            initValue = GeneratorUtils.createRandomValue(param.getType(), true);
        }
        if (initValue.equals(value)) {
            return testCases;
        }
        tc = this.createTestCase();
        pa = this.of.createParamAssignment();
        pa.setParamName(param.getName());
        pa.setAssignment(initValue);
        tc.getParamAssignments().add(pa);
        testCases.add(tc);
        return testCases;
    }

    private Collection<? extends TestCase> createTestCasesForCompare(ExpressionAnalyzer ec) {
        if (ec.getNumberLiteral() != null) {
            String number = ec.getNumberLiteral().getToken();
            if (ec.getParam() != null) {
                return this.createTestCasesForCompare(number, ec.getParam());
            }
            if (ec.getSimpleName() != null) {
                return this.createTestCasesForCompare(number, ec.getSimpleName());
            }
        } else if (ec.getParam() != null) {
            if (ec.getParamSecond() != null) {
                return this.createTestCasesForCompare(ec.getParam(), ec.getParamSecond());
            }
            if (ec.getParamSecond() != null) {
                return this.createTestCasesForCompare(ec.getParam(), ec.getSimpleName());
            }
        }
        return EMPTY_LIST_TC;
    }

    private Collection<? extends TestCase> createTestCasesForCompare(Param param, Expression expression) {
        return EMPTY_LIST_TC;
    }

    private Collection<? extends TestCase> createTestCasesForCompare(Param param, Param paramSecond) {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        List<String> comb = GeneratorUtils.createCombination(param.getType());
        if (comb.size() == 0) {
            return testCases;
        }
        ParamAssignment pa1 = this.of.createParamAssignment();
        pa1.setParamName(param.getName());
        pa1.setAssignment(comb.get(0));
        for (String paramValue : comb) {
            TestCase tc = this.createTestCase();
            ParamAssignment pa2 = this.of.createParamAssignment();
            pa2.setParamName(paramSecond.getName());
            pa2.setAssignment(paramValue);
            tc.getParamAssignments().add(pa1);
            tc.getParamAssignments().add(pa2);
            testCases.add(tc);
        }
        return testCases;
    }

    private Collection<? extends TestCase> createTestCasesForCompare(String number, Expression simpleName) {
        return EMPTY_LIST_TC;
    }

    private List<TestCase> createTestCasesForCompare(String number, Param param) {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        List<String> comb = GeneratorUtils.createCombination(param.getType(), number);
        for (String paramValue : comb) {
            TestCase tc = this.createTestCase();
            ParamAssignment pa = this.of.createParamAssignment();
            pa.setParamName(param.getName());
            pa.setAssignment(paramValue);
            tc.getParamAssignments().add(pa);
            testCases.add(tc);
        }
        return testCases;
    }

    public void generateTestCases(GeneratorModel utmModel) throws JavaModelException {
        for (IMethod method : utmModel.getMethodsToCreate()) {
            Method tmlMethod = utmModel.getMethodMap().get(method);
            TestCase testCase = this.of.createTestCase();
            this.analyzeBaseMethod(method, tmlMethod);
            if (tmlMethod.getTestCase().size() == 0) {
                testCase.setTestBase("");
                testCase.setName("default test");
                tmlMethod.getTestCase().add(testCase);
                continue;
            }
            int i = 1;
            for (TestCase tc : tmlMethod.getTestCase()) {
                tc.setName(String.valueOf(tc.getName()) + " " + i++);
            }
        }
    }

    protected Number getNumber(NumberLiteral numberLiteral) {
        String sNumber = numberLiteral.getToken();
        Integer number = 0;
        try {
            number = Integer.parseInt(sNumber);
        }
        catch (NumberFormatException numberFormatException) {
            number = 0;
        }
        return number;
    }

    protected String getNumber(PrefixExpression prefixExpression) {
        String number = null;
        Expression operand = prefixExpression.getOperand();
        if (operand.getNodeType() == 34) {
            PrefixExpression.Operator operator = prefixExpression.getOperator();
            number = PrefixExpression.Operator.MINUS.equals(operator) ? "-" + operand.toString() : (PrefixExpression.Operator.PLUS.equals(operator) || PrefixExpression.Operator.DECREMENT.equals(operator) || PrefixExpression.Operator.INCREMENT.equals(operator) ? operand.toString() : "0");
        }
        return number;
    }

    private boolean isChainOperator(InfixExpression.Operator operator) {
        return operator == InfixExpression.Operator.AND || operator == InfixExpression.Operator.CONDITIONAL_AND || operator == InfixExpression.Operator.OR || operator == InfixExpression.Operator.CONDITIONAL_OR || operator == InfixExpression.Operator.XOR;
    }

    private boolean isParamVariable(List<Param> params, String variableName) {
        for (Param param : params) {
            if (!param.getName().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    private List<TestCase> mergeTestCases(List<TestCase> tcList1, List<TestCase> tcList2) {
        boolean duplicateFound;
        ArrayList<TestCase> mergedTcList = new ArrayList<TestCase>();
        if (tcList2.size() == 0) {
            return tcList1;
        }
        if (tcList1.size() == 0) {
            return tcList2;
        }
        for (TestCase tc1 : tcList1) {
            for (TestCase tc2 : tcList2) {
                for (ParamAssignment pa2 : tc2.getParamAssignments()) {
                    duplicateFound = false;
                    for (ParamAssignment pa1 : tc1.getParamAssignments()) {
                        if (!pa1.getParamName().equals(pa2.getParamName())) continue;
                        duplicateFound = true;
                        break;
                    }
                    if (duplicateFound) continue;
                    tc1.getParamAssignments().add(pa2);
                }
            }
        }
        for (TestCase tc2 : tcList2) {
            for (TestCase tc1 : tcList1) {
                for (ParamAssignment pa1 : tc1.getParamAssignments()) {
                    duplicateFound = false;
                    for (ParamAssignment pa2 : tc2.getParamAssignments()) {
                        if (!pa2.getParamName().equals(pa1.getParamName())) continue;
                        duplicateFound = true;
                        break;
                    }
                    if (duplicateFound) continue;
                    tc2.getParamAssignments().add(pa1);
                }
            }
        }
        mergedTcList.addAll(tcList1);
        mergedTcList.addAll(tcList2);
        return mergedTcList;
    }

    private List<TestCase> multiplyTestCases(List<TestCase> tcList1, List<TestCase> tcList2) {
        ArrayList<TestCase> mergedTcList = new ArrayList<TestCase>();
        if (tcList2.size() == 0) {
            return tcList1;
        }
        if (tcList1.size() == 0) {
            return tcList2;
        }
        for (TestCase tc1 : tcList1) {
            for (TestCase tc2 : tcList2) {
                TestCase mergedTc = this.of.createTestCase();
                mergedTc.setTestBase(tc1.getTestBase());
                mergedTc.setName(tc1.getName());
                mergedTc.getPreconditions().addAll(tc1.getPreconditions());
                mergedTc.getPreconditions().addAll(tc2.getPreconditions());
                mergedTc.getParamAssignments().addAll(tc1.getParamAssignments());
                mergedTc.getParamAssignments().addAll(tc2.getParamAssignments());
                mergedTc.getAssertion().addAll(tc1.getAssertion());
                mergedTc.getAssertion().addAll(tc2.getAssertion());
                mergedTcList.add(mergedTc);
            }
        }
        return mergedTcList;
    }

    private List<TestCase> processIfExpressions(Expression expression, Method tmlMethod) {
        List<Param> tmlMethodParam = tmlMethod.getParam();
        ArrayList<TestCase> allTestCases = new ArrayList<TestCase>();
        if (expression.getNodeType() == 27) {
            InfixExpression infixExpression = (InfixExpression)expression;
            Expression leftOperand = infixExpression.getLeftOperand();
            Expression rightOperand = infixExpression.getRightOperand();
            InfixExpression.Operator operator = infixExpression.getOperator();
            List<TestCase> tcLeftOperand = this.processIfExpressions(leftOperand, tmlMethod);
            List<TestCase> tcRightOperand = this.processIfExpressions(rightOperand, tmlMethod);
            ExpressionAnalyzer ec = new ExpressionAnalyzer(tmlMethod);
            ec.analyze(leftOperand);
            ec.analyze(rightOperand);
            ec.setOperator(operator);
            if (this.isChainOperator(operator)) {
                allTestCases.addAll(this.mergeTestCases(tcLeftOperand, tcRightOperand));
            } else if (operator == InfixExpression.Operator.NOT_EQUALS || operator == InfixExpression.Operator.EQUALS) {
                if (ec.getParam() != null) {
                    if (ec.getNullLiteral() != null) {
                        allTestCases.addAll(this.createTestcaseForCheck(ec.getParam(), "null"));
                    } else if (ec.getNumberLiteral() != null) {
                        allTestCases.addAll(this.createTestcaseForCheck(ec.getParam(), "" + this.getNumber(ec.getNumberLiteral())));
                    }
                }
            } else if (operator == InfixExpression.Operator.LESS || operator == InfixExpression.Operator.LESS_EQUALS || operator == InfixExpression.Operator.GREATER || operator == InfixExpression.Operator.GREATER_EQUALS) {
                allTestCases.addAll(this.createTestCasesForCompare(ec));
            } else {
                allTestCases.addAll(tcLeftOperand);
                allTestCases.addAll(tcRightOperand);
            }
        } else if (expression.getNodeType() == 32) {
            MethodInvocation mi = (MethodInvocation)expression;
            String methodName = mi.getName().toString();
            Expression methodExpression = mi.getExpression();
            List arguments = mi.arguments();
            if (methodName.equals("equals")) {
                if (methodExpression.getNodeType() == 45) {
                    for (Object argumentO : arguments) {
                        ASTNode argumentNode;
                        if (!(argumentO instanceof ASTNode) || (argumentNode = (ASTNode)argumentO).getNodeType() != 42 || !this.isParamVariable(tmlMethodParam, argumentNode.toString())) continue;
                        TestCase tc = this.createTestCase();
                        ParamAssignment pa = this.of.createParamAssignment();
                        pa.setParamName(argumentNode.toString());
                        pa.setAssignment(methodExpression.toString());
                        tc.getParamAssignments().add(pa);
                        allTestCases.add(tc);
                    }
                } else if (methodExpression.getNodeType() == 42 && this.isParamVariable(tmlMethodParam, methodExpression.toString())) {
                    for (Object argumentO : arguments) {
                        ASTNode argumentNode;
                        if (!(argumentO instanceof ASTNode) || (argumentNode = (ASTNode)argumentO).getNodeType() != 45) continue;
                        TestCase tc = this.createTestCase();
                        ParamAssignment pa = this.of.createParamAssignment();
                        pa.setParamName(methodExpression.toString());
                        pa.setAssignment(argumentNode.toString());
                        tc.getParamAssignments().add(pa);
                        allTestCases.add(tc);
                    }
                }
            }
        } else if (expression.getNodeType() == 36) {
            Expression mainExpression = ((ParenthesizedExpression)expression).getExpression();
            return this.processIfExpressions(mainExpression, tmlMethod);
        }
        return allTestCases;
    }

    private void processIfStatements(Statement st, Method tmlMethod) {
        List<TestCase> testCases = tmlMethod.getTestCase();
        if (st != null && st.getNodeType() == 25) {
            IfStatement ifSt = (IfStatement)st;
            Expression expression = ifSt.getExpression();
            testCases.addAll(this.processIfExpressions(expression, tmlMethod));
            for (TestCase tc : testCases) {
                if (tc.getAssertion().size() != 0 || tmlMethod.getResult() == null) continue;
                Assertion assertion = this.of.createAssertion();
                assertion.setType(AssertionType.EQUALS);
                assertion.setBase("{result}");
                assertion.setValue("");
                tc.getAssertion().add(assertion);
            }
            this.processIfStatements(ifSt.getThenStatement(), tmlMethod);
            this.processIfStatements(ifSt.getElseStatement(), tmlMethod);
        }
    }

    public class ExpressionAnalyzer {
        private final Map<Expression, Integer> expressionOrder = new HashMap<Expression, Integer>();
        private final Map<Expression, PostfixExpression.Operator> expressionPostfixes = new HashMap<Expression, PostfixExpression.Operator>();
        private final Map<Expression, PrefixExpression.Operator> expressionPrefixes = new HashMap<Expression, PrefixExpression.Operator>();
        int filledCount = 0;
        List<NullLiteral> nullLiterals = new ArrayList<NullLiteral>();
        List<NumberLiteral> numberLiterals = new ArrayList<NumberLiteral>();
        private InfixExpression.Operator operator;
        private List<Param> paramBaseList = null;
        private final List<Param> params = new ArrayList<Param>();
        List<PostfixExpression> postfixExpressions = new ArrayList<PostfixExpression>();
        List<PrefixExpression> prefixExpressions = new ArrayList<PrefixExpression>();
        List<SimpleName> simpleNames = new ArrayList<SimpleName>();
        private final List<List<TestCase>> testCasesToMerge = new ArrayList<List<TestCase>>();
        private Method tmlMethod = null;

        public ExpressionAnalyzer() {
        }

        public ExpressionAnalyzer(Method tmlMethod) {
            this.tmlMethod = tmlMethod;
            this.paramBaseList = tmlMethod.getParam();
        }

        private void addTestCasesToMerge(List<TestCase> testCasesToMerge) {
            this.testCasesToMerge.add(testCasesToMerge);
        }

        public void analyze(Expression expression) {
            if (expression.getNodeType() == 33) {
                this.setNullLiteral((NullLiteral)expression);
            } else if (expression.getNodeType() == 42) {
                this.setSimpleName((SimpleName)expression);
            } else if (expression.getNodeType() == 34) {
                this.setNumberLiteral((NumberLiteral)expression);
            } else if (expression.getNodeType() == 38) {
                this.setPrefixExpression((PrefixExpression)expression);
            } else if (expression.getNodeType() == 37) {
                this.setPostfixExpression((PostfixExpression)expression);
            } else if (expression.getNodeType() != 36 && expression.getNodeType() != 27 && expression.getNodeType() != 32) {
                System.out.println("Expression could not be analyzed: " + expression.getNodeType() + ". Expression: " + expression.toString());
            }
        }

        private Expression getExpressionFromList(List<? extends Expression> expressions, int i) {
            if (expressions.size() > i) {
                return expressions.get(i);
            }
            return null;
        }

        public Expression getNullLiteral() {
            return this.getExpressionFromList(this.nullLiterals, 0);
        }

        public Expression getNullLiteralSecond() {
            return this.getExpressionFromList(this.nullLiterals, 1);
        }

        public NumberLiteral getNumberLiteral() {
            return (NumberLiteral)this.getExpressionFromList(this.numberLiterals, 0);
        }

        public Expression getNumberLiteralSecond() {
            return this.getExpressionFromList(this.numberLiterals, 1);
        }

        public InfixExpression.Operator getOperator() {
            return this.operator;
        }

        public Param getParam() {
            return this.getParam(0);
        }

        public Param getParam(int i) {
            if (this.params.size() > i) {
                return this.params.get(i);
            }
            return null;
        }

        public Param getParamSecond() {
            return this.getParam(1);
        }

        public PostfixExpression getPostfixExpression() {
            return (PostfixExpression)this.getExpressionFromList(this.postfixExpressions, 0);
        }

        public List<PostfixExpression> getPostfixExpressions() {
            return this.postfixExpressions;
        }

        public PostfixExpression getPostfixExpressionSecond() {
            return (PostfixExpression)this.getExpressionFromList(this.postfixExpressions, 1);
        }

        public PrefixExpression getPrefixExpression() {
            return (PrefixExpression)this.getExpressionFromList(this.prefixExpressions, 0);
        }

        public List<PrefixExpression> getPrefixExpressions() {
            return this.prefixExpressions;
        }

        public PrefixExpression getPrefixExpressionSecond() {
            return (PrefixExpression)this.getExpressionFromList(this.prefixExpressions, 1);
        }

        public Expression getSimpleName() {
            return this.getExpressionFromList(this.simpleNames, 0);
        }

        public Expression getSimpleNameSecond() {
            return this.getExpressionFromList(this.simpleNames, 1);
        }

        public List<List<TestCase>> getTestCasesToMerge() {
            return this.testCasesToMerge;
        }

        public void setNullLiteral(NullLiteral nullLiteral) {
            this.expressionOrder.put((Expression)nullLiteral, this.filledCount++);
            this.nullLiterals.add(nullLiteral);
        }

        public void setNumberLiteral(NumberLiteral numberLiteral) {
            this.expressionOrder.put((Expression)numberLiteral, this.filledCount++);
            this.numberLiterals.add(numberLiteral);
        }

        public void setOperator(InfixExpression.Operator operator) {
            this.operator = operator;
        }

        private void setParam(String name) {
            for (Param tmpParam : this.paramBaseList) {
                if (!tmpParam.getName().equals(name)) continue;
                this.params.add(tmpParam);
                return;
            }
        }

        private void setParenthesizedExpression(ParenthesizedExpression expression) {
            Expression mainExpression = expression.getExpression();
            this.analyze(mainExpression);
        }

        public void setPostfixExpression(PostfixExpression expression) {
            this.postfixExpressions.add(expression);
            Expression operand = expression.getOperand();
            this.expressionPostfixes.put(operand, expression.getOperator());
            this.analyze(operand);
        }

        public void setPrefixExpression(PrefixExpression expression) {
            this.prefixExpressions.add(expression);
            Expression operand = expression.getOperand();
            this.expressionPrefixes.put(operand, expression.getOperator());
            this.analyze(operand);
        }

        public void setSimpleName(SimpleName simpleName) {
            this.expressionOrder.put((Expression)simpleName, this.filledCount++);
            this.simpleNames.add(simpleName);
            if (simpleName != null) {
                this.setParam(simpleName.toString());
            }
        }
    }
}

