/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.generator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.junit.tools.base.JUTWarning;
import org.junit.tools.base.MethodRef;
import org.junit.tools.generator.IGeneratorConstants;
import org.junit.tools.generator.IMockClassGenerator;
import org.junit.tools.generator.utils.GeneratorUtils;
import org.junit.tools.generator.utils.JDTUtils;
import org.junit.tools.ui.generator.wizards.MockGeneratorWizard;
import org.junit.tools.ui.utils.EclipseUIUtils;

public class MockClassGenerator
implements IMockClassGenerator,
IGeneratorConstants {
    private Logger logger = Logger.getLogger(MockClassGenerator.class.getName());
    private ICompilationUnit generatedCuMock = null;

    @Override
    public ICompilationUnit generate(IWorkbenchWindow activeWorkbenchWindow, IFileEditorInput fileEditorInput) throws JUTWarning, JavaModelException, CoreException {
        return this.generate(JDTUtils.getJavaElements(null, fileEditorInput), activeWorkbenchWindow);
    }

    @Override
    public ICompilationUnit generate(IWorkbenchWindow activeWorkbenchWindow, IStructuredSelection selection) throws JUTWarning, JavaModelException, CoreException {
        Vector<IJavaElement> javaElements = JDTUtils.getJavaElements((ISelection)selection, null, true);
        return this.generate(javaElements, activeWorkbenchWindow);
    }

    private ICompilationUnit generate(Vector<IJavaElement> javaElements, IWorkbenchWindow activeWorkbenchWindow) throws CoreException {
        MockGeneratorWizard wizard;
        IType mockedClass;
        if (javaElements.size() == 0) {
            return null;
        }
        IJavaElement iJavaElement = javaElements.get(0);
        if (iJavaElement instanceof ICompilationUnit && (mockedClass = this.findMockedClass((ICompilationUnit)iJavaElement)) != null) {
            iJavaElement = mockedClass.getParent();
        }
        if (!(wizard = this.openWizard(iJavaElement, activeWorkbenchWindow)).isFinished()) {
            return null;
        }
        ICompilationUnit generatedMock = this.generateMock(iJavaElement, wizard.getCheckedMethods(), wizard.getProject(), wizard.getTargetPackage(), wizard.isMockNew(), wizard.getMockClass(), wizard.getExistingMethods());
        if (generatedMock != null && generatedMock.exists()) {
            IWorkbenchPartSite site = activeWorkbenchWindow.getActivePage().getActivePart().getSite();
            EclipseUIUtils.organizeImports(site, generatedMock);
            EclipseUIUtils.format(site, generatedMock);
        }
        return generatedMock;
    }

    private ICompilationUnit generateMock(final IJavaElement cu, final Vector<IMethod> checkedMethods, final IJavaProject targetProject, final IPackageFragment targetPackageTmp, final boolean isMockNew, final ICompilationUnit mockClass, final HashMap<MethodRef, IMethod> existingMethods) throws CoreException {
        if (checkedMethods == null || checkedMethods.size() == 0) {
            return null;
        }
        JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MockClassGenerator.this.logger.log(Level.INFO, "generate mock for " + cu.getElementName() + " in " + targetProject.getElementName());
                if (targetPackageTmp == null) {
                    return;
                }
                IPackageFragment targetPackage = !targetPackageTmp.exists() ? JDTUtils.createPackage(targetProject, targetPackageTmp.getElementName()) : targetPackageTmp;
                ICompilationUnit cuMock = isMockNew ? MockClassGenerator.this.createMockClass(cu, targetPackage) : mockClass;
                for (IMethod methodToDelete : GeneratorUtils.getMethodsToDelete(existingMethods, checkedMethods)) {
                    methodToDelete.delete(true, null);
                }
                MockClassGenerator.this.createMockMethods(cu, cuMock, GeneratorUtils.getMethodsToCreate(existingMethods, checkedMethods));
                MockClassGenerator.this.save(cuMock);
            }
        }, null);
        return this.generatedCuMock;
    }

    protected void save(ICompilationUnit cuMock) throws OperationCanceledException, CoreException {
        this.generatedCuMock = cuMock;
        cuMock.save(null, true);
        cuMock.makeConsistent(null);
        if (cuMock.isWorkingCopy()) {
            cuMock.commitWorkingCopy(true, null);
        }
    }

    public ICompilationUnit regenerate(final ICompilationUnit oldMockClass, final ICompilationUnit baseClass, final Vector<IMethod> mockMethodsToCreate) throws CoreException {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MockClassGenerator.this.logger.log(Level.INFO, "regenerate mock for " + oldMockClass.getElementName() + " in " + oldMockClass.getJavaProject().getElementName());
                ICompilationUnit cuMock = MockClassGenerator.this.createMockClass((IJavaElement)baseClass, JDTUtils.getPackage((IJavaElement)oldMockClass));
                MockClassGenerator.this.createMockMethods((IJavaElement)baseClass, cuMock, mockMethodsToCreate);
                MockClassGenerator.this.save(cuMock);
            }
        };
        JavaCore.run((IWorkspaceRunnable)iWorkspaceRunnable, null);
        return this.generatedCuMock;
    }

    protected void setGeneratedMock(ICompilationUnit cuMock) {
        this.generatedCuMock = cuMock;
    }

    protected ICompilationUnit createMockClass(IJavaElement cu, IPackageFragment targetPackage) throws OperationCanceledException, CoreException {
        if (cu == null || !cu.exists()) {
            throw new RuntimeException("Source of class is not available!");
        }
        boolean isInterface = false;
        if (cu instanceof ICompilationUnit) {
            ICompilationUnit compU = (ICompilationUnit)cu;
            isInterface = compU.findPrimaryType().isInterface();
        }
        String cuName = cu.getElementName();
        String cuBaseName = cuName.replace(".java", "");
        cuBaseName = cuBaseName.replace(".class", "");
        String cuMockName = String.valueOf(cuBaseName) + "Mock.java";
        String cuMockNameTmp = String.valueOf(cuBaseName) + "Mock";
        String source = this.createMockClassBody(cuBaseName, cuMockNameTmp, isInterface);
        ICompilationUnit cuMock = targetPackage.getCompilationUnit(cuMockName);
        if (cuMock.isWorkingCopy()) {
            EclipseUIUtils.saveAndCloseEditor(cuMockName);
        }
        if (cuMock.exists()) {
            cuMock.delete(true, null);
        }
        cuMock = targetPackage.createCompilationUnit(cuMockName, source, true, null);
        cuMock.createPackageDeclaration(targetPackage.getElementName(), null);
        cuMock.createImport("java.util.*", null, null);
        JDTUtils.createMethod(cuMock.findPrimaryType(), "public static", cuMockNameTmp, "create", null, null, "return new " + cuMockNameTmp + "();", new String[0]);
        return cuMock;
    }

    protected String createMockClassBody(String cuBaseName, String cuMockNameTmp, boolean isInterface) {
        String extendsClause = "";
        extendsClause = isInterface ? " implements " + cuBaseName : " extends MockUp<" + cuBaseName + "> ";
        String annoGenerated = GeneratorUtils.createAnnoGenerated();
        String annotations = String.valueOf(annoGenerated) + this.createCustomAnnotations();
        String source = "/** Mock for { @link " + cuBaseName + " } */" + annotations + "public" + " class " + cuMockNameTmp + extendsClause + "{ " + "\n" + "}";
        return source;
    }

    protected String createCustomAnnotations() {
        return "";
    }

    private void createMockMethods(IJavaElement cuBase, ICompilationUnit cuMock, List<IMethod> methodsToMock) throws JavaModelException {
        IType baseType;
        IType mockType = cuMock.findPrimaryType();
        if (cuBase instanceof ICompilationUnit && (baseType = ((ICompilationUnit)cuBase).findPrimaryType()) != null && baseType.isInterface()) {
            this.createMockMethodsForInterface(mockType, baseType, methodsToMock);
            return;
        }
        this.createMockMethodsForClass(cuMock, mockType, methodsToMock);
    }

    private void createMockMethodsForClass(ICompilationUnit cuMock, IType type, List<IMethod> methodsToMock) throws JavaModelException {
        String returnValueName = "returnValue";
        StringBuilder newResetMethodsBody = new StringBuilder();
        String annoMock = "@Mock";
        for (IMethod methodToMock : methodsToMock) {
            String methodToMockName = methodToMock.getElementName();
            String methodToMockNameFirstCharUp = GeneratorUtils.firstCharToUpper(methodToMockName);
            String returnType = JDTUtils.createReturnType(methodToMock.getReturnType());
            int increment = -1;
            String varMocked = String.valueOf(methodToMockName) + "Mocked";
            String varExecutions = String.valueOf(methodToMockName) + "Executions";
            String varReturnValue = String.valueOf(methodToMockName) + "ReturnValue";
            IField createdField = JDTUtils.createField(type, "private", "boolean", varMocked, "false", true);
            increment = JDTUtils.getIncrement(createdField.getElementName(), null);
            if (increment != -1) {
                varMocked = String.valueOf(varMocked) + "_" + increment;
                varExecutions = String.valueOf(varExecutions) + "_" + increment;
                varReturnValue = String.valueOf(varReturnValue) + "_" + increment;
                methodToMockNameFirstCharUp = String.valueOf(methodToMockNameFirstCharUp) + "_" + increment;
            }
            JDTUtils.createField(type, "private", "int", varExecutions, "0", false);
            if (returnType.equals("void")) {
                varReturnValue = "";
            } else {
                JDTUtils.createField(type, "private", returnType, varReturnValue, JDTUtils.createInitValue(returnType, true), false);
            }
            String annoMethodRef = GeneratorUtils.createAnnoMethodRef(methodToMock);
            String methodParams = JDTUtils.createParamList(methodToMock);
            if (methodParams.length() > 0) {
                methodParams = ", " + methodParams;
            }
            methodParams = "Invocation inv" + methodParams;
            StringBuilder methodBody = new StringBuilder();
            methodBody.append(String.valueOf(varExecutions) + "++;" + "\n").append("if (").append(varMocked).append(") {").append("\n").append("return ").append(varReturnValue).append(";").append("}").append("\n").append(returnType.equals("void") ? "" : "return ").append("inv.proceed();");
            JDTUtils.createMethod(type, "", returnType, methodToMockName, null, methodParams, methodBody.toString(), annoMethodRef, annoMock);
            methodBody = new StringBuilder();
            if (returnType.equals("void")) {
                methodParams = "";
            } else {
                methodParams = String.valueOf(returnType) + " " + returnValueName;
                methodBody.append(varReturnValue).append(" = ").append(returnValueName).append(";").append("\n");
            }
            methodBody.append(varMocked).append(" = true;").append("\n");
            methodBody.append(varExecutions).append(" = 0;");
            JDTUtils.createMethod(type, "public", "void", "setUpMock" + methodToMockNameFirstCharUp, "", methodParams, methodBody.toString(), false, true, new String[0]);
            methodBody = new StringBuilder();
            methodBody.append("return ").append(varExecutions).append(";");
            JDTUtils.createMethod(type, "public", "int", "get" + GeneratorUtils.firstCharToUpper(varExecutions), "", "", methodBody.toString(), new String[0]);
            methodBody = new StringBuilder();
            methodBody.append("return ").append(varExecutions).append(" > 0;");
            JDTUtils.createMethod(type, "public", "boolean", "is" + methodToMockNameFirstCharUp + "Executed", "", "", methodBody.toString(), new String[0]);
            methodBody = new StringBuilder();
            methodBody.append(varMocked).append(" = false;").append("\n");
            methodBody.append(varExecutions).append(" = 0;");
            JDTUtils.createMethod(type, "public", "void", "resetMock" + methodToMockNameFirstCharUp, "", "", methodBody.toString(), new String[0]);
            newResetMethodsBody.append("resetMock").append(methodToMockNameFirstCharUp).append("();");
        }
        IMethod resetAllMethod = type.getMethod("resetAllMocks", new String[0]);
        if (resetAllMethod.exists()) {
            String source = resetAllMethod.getSource();
            int firstIndexOf = source.indexOf("{") + 1;
            int lastIndexOf = source.lastIndexOf("}");
            String body = source.substring(firstIndexOf, lastIndexOf);
            newResetMethodsBody.append(body);
        }
        JDTUtils.createMethod(type, "public", "void", "resetAllMocks", "", "", newResetMethodsBody.toString(), false, true, new String[0]);
    }

    private void createMockMethodsForInterface(IType mockType, IType baseType, List<IMethod> methodsToMock) throws JavaModelException {
        IMethod[] iMethodArray = baseType.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod baseMethod = iMethodArray[n2];
            String varName = "";
            String returnType = JDTUtils.createReturnType(baseMethod.getReturnType());
            if (!returnType.equals("void")) {
                varName = String.valueOf(baseMethod.getElementName()) + "Result";
                if (!"void".equals(returnType)) {
                    IField field = JDTUtils.createField(mockType, "private", returnType, varName, JDTUtils.createInitValue(returnType, true), true);
                    varName = field.getElementName();
                }
                JDTUtils.createMethod(mockType, "public", "void", "set" + GeneratorUtils.firstCharToUpper(varName), "", String.valueOf(returnType) + " " + varName, "this." + varName + " = " + varName + ";", false, true, new String[0]);
                JDTUtils.createMethod(mockType, baseMethod, "return " + varName + ";", "@Override");
            } else {
                JDTUtils.createMethod(mockType, baseMethod, "// nothing", "@Override");
            }
            ++n2;
        }
    }

    private MockGeneratorWizard openWizard(IJavaElement javaElement, IWorkbenchWindow activeWorkbenchWindow) throws CoreException {
        MockGeneratorWizard wizard = new MockGeneratorWizard(javaElement);
        WizardDialog dialog = new WizardDialog(activeWorkbenchWindow.getShell(), (IWizard)wizard);
        dialog.create();
        wizard.init();
        dialog.open();
        return wizard;
    }

    @Override
    public void cleanMock(ICompilationUnit cu) throws CoreException {
        IMethod[] methods;
        IType mockedClass = this.findMockedClass(cu);
        if (mockedClass == null) {
            return;
        }
        HashMap<MethodRef, IMethod> existingMethods = GeneratorUtils.getExistingTestMethods(null, cu, true);
        Vector<IMethod> mockMethodsToCreate = new Vector<IMethod>();
        Vector<IMethod> cleanMethods = new Vector<IMethod>();
        HashMap<String, IMethod> dirtyMethods = new HashMap<String, IMethod>();
        IMethod[] iMethodArray = methods = mockedClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            for (MethodRef methodRef : existingMethods.keySet()) {
                String methodRefName = methodRef.getName().startsWith("setUpMock") ? GeneratorUtils.firstCharToLower(methodRef.getName().substring(9)) : methodRef.getName();
                if (!method.getElementName().equals(methodRefName)) continue;
                if (method.getSignature().equals(methodRef.getSignature())) {
                    cleanMethods.add(method);
                    break;
                }
                if (dirtyMethods.containsKey(method.getElementName())) continue;
                dirtyMethods.put(method.getElementName(), method);
            }
            ++n2;
        }
        mockMethodsToCreate.addAll(cleanMethods);
        for (Map.Entry dirtyMethodEntry : dirtyMethods.entrySet()) {
            boolean found = false;
            for (IMethod method : cleanMethods) {
                if (!method.getElementName().equals(dirtyMethodEntry.getKey())) continue;
                found = true;
                break;
            }
            if (found || mockMethodsToCreate.contains(dirtyMethodEntry.getValue())) continue;
            mockMethodsToCreate.add((IMethod)dirtyMethodEntry.getValue());
        }
        this.regenerate(cu, mockedClass.getCompilationUnit(), mockMethodsToCreate);
    }

    private IType findMockedClass(ICompilationUnit mockClass) throws JavaModelException {
        String elementName;
        IType type = mockClass.findPrimaryType();
        if (type == null || !type.exists()) {
            return null;
        }
        String mockedClassName = null;
        String superclassName = type.getSuperclassName();
        if (superclassName != null && superclassName.indexOf("MockUp<") > -1) {
            int ixStart = superclassName.indexOf("<") + 1;
            int ixEnd = superclassName.indexOf(">");
            mockedClassName = superclassName.substring(ixStart, ixEnd);
        }
        if (mockedClassName == null && (elementName = type.getElementName()).endsWith("Mock")) {
            int endIndex = elementName.indexOf("Mock");
            mockedClassName = elementName.substring(0, endIndex);
        }
        if (mockedClassName == null) {
            return null;
        }
        String fullQualifiedName = JDTUtils.getFullQualifiedName(mockClass.findPrimaryType(), mockedClassName);
        if (fullQualifiedName != null) {
            IJavaProject[] iJavaProjectArray = mockClass.getJavaModel().getJavaProjects();
            int n = iJavaProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject project = iJavaProjectArray[n2];
                IType mockedClass = project.findType(fullQualifiedName);
                if (mockedClass != null && mockedClass.exists()) {
                    return mockedClass;
                }
                ++n2;
            }
        }
        return null;
    }
}

