/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.base;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;

public class MethodRef {
    private String name;
    private String signature;
    private boolean signatureChanged = false;
    private String signatureNew;
    private boolean unresolvedConflict = false;

    public MethodRef(String name, String signature) {
        this.name = name;
        this.signature = signature;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public String toString() {
        return String.valueOf(this.name) + this.signature;
    }

    public boolean isSignatureChanged() {
        return this.signatureChanged;
    }

    public void setSignatureChanged(boolean signatureChanged) {
        this.signatureChanged = signatureChanged;
    }

    public void setSignatureNew(String signatureNew) {
        this.setSignatureChanged(true);
        this.signatureNew = signatureNew;
    }

    public String getSignatureNew() {
        return this.signatureNew;
    }

    public void setUnresolvedConflict(boolean unresolvedConflict) {
        this.unresolvedConflict = unresolvedConflict;
    }

    public boolean isUnresolvedConflict() {
        return this.unresolvedConflict;
    }

    public String getSignatureToCompare() {
        if (this.isSignatureChanged()) {
            return this.getSignatureNew();
        }
        return this.getSignature();
    }

    public boolean isEquals(MethodRef mrToCompare) {
        return mrToCompare.getName().equals(this.getName()) && mrToCompare.getSignatureToCompare().equals(this.getSignatureToCompare());
    }

    public boolean isEquals(IMethod methodToCompare) {
        try {
            return this.isEquals(new MethodRef(methodToCompare.getElementName(), methodToCompare.getSignature()));
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

