/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.junit.tools.generator.model.tml.Testprio;
import org.junit.tools.generator.utils.JDTUtils;

public class MethodAnalyzer {
    private List<IfStatement> collectIfStatements(Statement st) {
        ArrayList<IfStatement> ifStatements = new ArrayList<IfStatement>();
        if (st == null) {
            return ifStatements;
        }
        if (st.getNodeType() == 25) {
            IfStatement ifSt = (IfStatement)st;
            ifStatements.add(ifSt);
            ifStatements.addAll(this.collectIfStatements(ifSt.getThenStatement()));
            ifStatements.addAll(this.collectIfStatements(ifSt.getElseStatement()));
        } else if (st.getNodeType() == 8) {
            Block block = (Block)st;
            for (Object blockSt : block.statements()) {
                if (!(blockSt instanceof Statement)) continue;
                ifStatements.addAll(this.collectIfStatements((Statement)blockSt));
            }
        } else if (st.getNodeType() == 19) {
            DoStatement doSt = (DoStatement)st;
            ifStatements.addAll(this.collectIfStatements(doSt.getBody()));
        } else if (st.getNodeType() == 61) {
            WhileStatement whileSt = (WhileStatement)st;
            ifStatements.addAll(this.collectIfStatements(whileSt.getBody()));
        }
        return ifStatements;
    }

    public Map<IMethod, MethodAnalyzeResult> analyzeAllMethods(ICompilationUnit cu) throws JavaModelException {
        HashMap<IMethod, MethodAnalyzeResult> analyzeResult = new HashMap<IMethod, MethodAnalyzeResult>();
        CompilationUnit astCu = JDTUtils.createASTRoot(cu);
        IType[] iTypeArray = cu.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            IMethod[] iMethodArray = type.getMethods();
            int n3 = iMethodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMethod method = iMethodArray[n4];
                MethodAnalyzeResult mar = this.analyzeMethod(astCu, method);
                if (mar != null && mar.getTestPrio() != null) {
                    analyzeResult.put(method, mar);
                }
                ++n4;
            }
            ++n2;
        }
        return analyzeResult;
    }

    private MethodAnalyzeResult analyzeMethod(CompilationUnit astCu, IMethod method) {
        MethodAnalyzeResult mar = new MethodAnalyzeResult();
        MethodDeclaration md = JDTUtils.createMethodDeclaration(astCu, method);
        if (md == null) {
            return mar;
        }
        List<IfStatement> ifStatements = this.collectIfStatements(md);
        int numberOfIfStatements = ifStatements.size();
        mar.setIfStatements(ifStatements);
        if (ifStatements.size() > 0) {
            boolean onlyNullChecks = true;
            for (IfStatement ifSt : ifStatements) {
                Expression expression = ifSt.getExpression();
                if (expression.getNodeType() == 27) {
                    InfixExpression infixEx = (InfixExpression)expression;
                    Expression leftOperand = infixEx.getLeftOperand();
                    Expression rightOperand = infixEx.getRightOperand();
                    InfixExpression.Operator operator = infixEx.getOperator();
                    if (!(!operator.equals(InfixExpression.Operator.EQUALS) && !operator.equals(InfixExpression.Operator.NOT_EQUALS) || leftOperand.getNodeType() != 33 && rightOperand.getNodeType() != 33)) continue;
                }
                onlyNullChecks = false;
            }
            mar.setOnlyNullChecks(onlyNullChecks);
        }
        if (numberOfIfStatements > 6) {
            mar.setTestPrio(Testprio.HIGH);
        } else if (numberOfIfStatements > 3) {
            mar.setTestPrio(Testprio.DEFAULT);
        } else if (numberOfIfStatements > 0) {
            mar.setTestPrio(Testprio.LOW);
        } else {
            mar.setTestPrio(null);
        }
        return mar;
    }

    private List<IfStatement> collectIfStatements(MethodDeclaration md) {
        ArrayList<IfStatement> ifStatements = new ArrayList<IfStatement>();
        Block body = md.getBody();
        if (body == null) {
            return ifStatements;
        }
        for (Object statement : body.statements()) {
            if (!(statement instanceof Statement)) continue;
            Statement st = (Statement)statement;
            ifStatements.addAll(this.collectIfStatements(st));
        }
        return ifStatements;
    }

    public class MethodAnalyzeResult {
        private Testprio testPrio = Testprio.DEFAULT;
        private List<IfStatement> ifStatements = new ArrayList<IfStatement>();
        private boolean onlyNullChecks = false;

        public Testprio getTestPrio() {
            return this.testPrio;
        }

        public void setTestPrio(Testprio testPrio) {
            this.testPrio = testPrio;
        }

        public List<IfStatement> getIfStatements() {
            return this.ifStatements;
        }

        public void setIfStatements(List<IfStatement> ifInstructions) {
            this.ifStatements = ifInstructions;
        }

        public boolean isOnlyNullChecks() {
            return this.onlyNullChecks;
        }

        public void setOnlyNullChecks(boolean onlyNullChecks) {
            this.onlyNullChecks = onlyNullChecks;
        }

        public int getNumberOfIfStatements() {
            return this.ifStatements.size();
        }
    }
}

