/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.junit.tools.Activator;
import org.junit.tools.base.ExtensionPointHandler;
import org.junit.tools.base.JUTException;
import org.junit.tools.base.JUTWarning;
import org.junit.tools.base.MethodRef;
import org.junit.tools.generator.IGeneratorConstants;
import org.junit.tools.generator.ITestClassGenerator;
import org.junit.tools.generator.ITestSuitesGenerator;
import org.junit.tools.generator.TestCasesGenerator;
import org.junit.tools.generator.model.GeneratorModel;
import org.junit.tools.generator.model.JUTElements;
import org.junit.tools.generator.model.tml.Settings;
import org.junit.tools.generator.model.tml.TMLProcessor;
import org.junit.tools.generator.model.tml.Test;
import org.junit.tools.generator.utils.GeneratorUtils;
import org.junit.tools.generator.utils.JDTUtils;
import org.junit.tools.messages.Messages;
import org.junit.tools.preferences.JUTPreferences;
import org.junit.tools.reports.ReportCreator;
import org.junit.tools.ui.generator.wizards.GeneratorWizard;
import org.junit.tools.ui.utils.EclipseUIUtils;

public class MainController
implements IGeneratorConstants {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private ICompilationUnit generatedTestClass = null;
    private boolean warning = false;
    private JUTWarning warningException;
    private boolean error = false;
    private Exception errorException;
    private int methodsCounter = 0;
    private ExtensionPointHandler extensionHandler = null;

    public boolean generateTestclass(IWorkbenchWindow activeWorkbenchWindow, IStructuredSelection selection) throws JUTException, JUTWarning, CoreException {
        JUTElements jutElements = this.detectJUTElements(selection, null);
        return this.generateTestclass(activeWorkbenchWindow, jutElements);
    }

    public boolean generateTestclass(IWorkbenchWindow activeWorkbenchWindow, IFileEditorInput fileEditorInput) throws JUTException, JUTWarning, CoreException {
        JUTElements jutElements = this.detectJUTElements(null, fileEditorInput);
        return this.generateTestclass(activeWorkbenchWindow, jutElements);
    }

    protected ExtensionPointHandler getExtensionHandler() {
        if (this.extensionHandler == null) {
            this.extensionHandler = Activator.getDefault().getExtensionHandler();
        }
        return this.extensionHandler;
    }

    protected boolean generateTestclass(IWorkbenchWindow activeWorkbenchWindow, JUTElements jutElements) throws JUTException, JUTWarning {
        GeneratorModel model;
        TMLProcessor tmlProcessor;
        boolean writeTML;
        ICompilationUnit testClass;
        String testClassName;
        block18: {
            if (jutElements == null) {
                throw new JUTWarning("No elements found! Perhaps baseclass changed.");
            }
            JUTElements.JUTProjects projects = jutElements.getProjects();
            if (projects == null) {
                throw new JUTWarning("No project found! Perhaps baseclass changed.");
            }
            IJavaProject testProject = projects.getTestProject();
            JUTElements.JUTClassesAndPackages classesAndPackages = jutElements.getClassesAndPackages();
            String testPackageName = classesAndPackages.getTestPackageName();
            testClassName = classesAndPackages.getTestClassName();
            testClass = classesAndPackages.getTestClass();
            writeTML = JUTPreferences.isWriteTML();
            Test tmlTest = null;
            tmlProcessor = null;
            if (writeTML && testClass != null && testClass.exists()) {
                tmlProcessor = new TMLProcessor(testProject, testPackageName, testClassName);
                tmlTest = tmlProcessor.readTmlFile();
            }
            if (this.runGeneratorWizard(model = new GeneratorModel(jutElements, tmlTest), activeWorkbenchWindow)) break block18;
            return false;
        }
        try {
            try {
                TestCasesGenerator tcg = new TestCasesGenerator();
                tcg.generateTestCases(model);
            }
            catch (Exception ex) {
                this.logger.warning("Exception occured during the test-cases-generation! " + ex.getMessage());
            }
            if (writeTML) {
                tmlProcessor.writeTmlFile(model.getTmlTest());
            }
            EclipseUIUtils.saveAndCloseEditor(testClassName);
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        ICompilationUnit generatedClass = null;
                        for (ITestClassGenerator testClassGenerator : MainController.this.getExtensionHandler().getTestClassGenerators()) {
                            generatedClass = testClassGenerator.generate(model, MainController.this.getExtensionHandler().getTestDataFactories(), monitor);
                        }
                        MainController.this.setGeneratedTestClass(generatedClass);
                        monitor.done();
                    }
                    catch (Exception e) {
                        MainController.this.setError(true, e);
                    }
                }
            };
            this.setError(false);
            try {
                activeWorkbenchWindow.run(true, true, runnableWithProgress);
            }
            catch (Exception ex) {
                throw new JUTException(ex);
            }
            if (this.isError()) {
                throw new JUTException(this.errorException);
            }
            IWorkbenchPartSite site = activeWorkbenchWindow.getActivePage().getActivePart().getSite();
            EclipseUIUtils.organizeImports(site, testClass);
            EclipseUIUtils.format(site, testClass);
            Settings settings = model.getTmlTest().getSettings();
            ArrayList<ICompilationUnit> generateTestSuites = null;
            if (settings != null) {
                if (settings.isTestsuites()) {
                    generateTestSuites = this.generateTestSuites(jutElements);
                }
            } else {
                this.generateTestSuites(jutElements);
            }
            if (generateTestSuites != null) {
                for (ICompilationUnit cu : generateTestSuites) {
                    EclipseUIUtils.organizeImports(site, cu);
                }
                EclipseUIUtils.format(site, generateTestSuites.toArray(new ICompilationUnit[generateTestSuites.size()]));
            }
            this.openInEditor(activeWorkbenchWindow.getShell(), (IFile)this.getGeneratedTestClass().getResource());
        }
        catch (JUTException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JUTException(ex);
        }
        return true;
    }

    protected void setError(boolean error, Exception ex) {
        this.setError(error);
        this.errorException = ex;
    }

    protected ArrayList<ICompilationUnit> generateTestSuites(JUTElements jutElements) throws CoreException {
        Iterator<ITestSuitesGenerator> iterator = Activator.getDefault().getExtensionHandler().getTestSuitesGenerators().iterator();
        if (iterator.hasNext()) {
            ITestSuitesGenerator testSuitesGenerator = iterator.next();
            testSuitesGenerator.generateTestSuites(jutElements);
            return testSuitesGenerator.getGeneratedTestSuites();
        }
        return new ArrayList<ICompilationUnit>();
    }

    private ICompilationUnit getGeneratedTestClass() {
        return this.generatedTestClass;
    }

    protected void setGeneratedTestClass(ICompilationUnit generatedClass) {
        this.generatedTestClass = generatedClass;
    }

    protected void openInEditor(Shell shell, IFile generatedTestclass) {
        EclipseUIUtils.openInEditor(shell, generatedTestclass);
    }

    private JUTElements detectJUTElements(ISelection selection) throws JUTException, JUTWarning, CoreException {
        if (selection instanceof IStructuredSelection) {
            return this.detectJUTElements((IStructuredSelection)selection, null);
        }
        if (selection instanceof IFileEditorInput) {
            return this.detectJUTElements(null, (IFileEditorInput)selection);
        }
        return null;
    }

    private JUTElements detectJUTElements(IStructuredSelection selection, IFileEditorInput fileEditorInput) throws JUTException, JUTWarning, CoreException {
        JUTElements jutElements = new JUTElements();
        if ((selection == null || selection.isEmpty()) && fileEditorInput == null) {
            IEditorInput editorInput = EclipseUIUtils.getEditorInput();
            if (editorInput != null && editorInput instanceof IFileEditorInput) {
                fileEditorInput = (IFileEditorInput)editorInput;
            } else {
                throw new JUTWarning(Messages.General_warning_nothing_selected);
            }
        }
        IJavaProject project = JDTUtils.getProject((ISelection)selection, fileEditorInput);
        jutElements.initProjects(project);
        Vector<IJavaElement> elements = JDTUtils.getCompilationUnits((ISelection)selection, fileEditorInput);
        Vector<ICompilationUnit> cuList = new Vector<ICompilationUnit>();
        for (IJavaElement element : elements) {
            if (!(element instanceof ICompilationUnit)) continue;
            cuList.add((ICompilationUnit)element);
        }
        if (cuList.size() > 0) {
            jutElements.initClassesAndPackages(cuList);
            if (!jutElements.getClassesAndPackages().getBaseClass().exists()) {
                return jutElements;
            }
            jutElements.setConstructorsAndMethods(this.getConstructorsAndMethods(jutElements.getClassesAndPackages().getBaseClass()));
            IMethod selectedMethod = null;
            if (selection != null) {
                Object firstElement = selection.getFirstElement();
                if (firstElement != null && firstElement instanceof IMethod) {
                    selectedMethod = (IMethod)firstElement;
                }
            } else if (fileEditorInput != null) {
                selectedMethod = JDTUtils.getSelectedMethod(fileEditorInput);
            }
            jutElements.getConstructorsAndMethods().setSelectedMethod(selectedMethod);
        }
        return jutElements;
    }

    private JUTElements.JUTConstructorsAndMethods getConstructorsAndMethods(ICompilationUnit baseclass) {
        Vector<IMethod> baseclassConstructors = new Vector<IMethod>();
        Vector<IMethod> baseclassMethods = new Vector<IMethod>();
        try {
            IType[] iTypeArray = baseclass.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                IMethod[] iMethodArray = type.getMethods();
                int n3 = iMethodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMethod method = iMethodArray[n4];
                    if (method.isConstructor()) {
                        baseclassConstructors.add(method);
                    } else {
                        baseclassMethods.add(method);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        JUTElements.JUTConstructorsAndMethods constructorsAndMethods = new JUTElements.JUTConstructorsAndMethods();
        constructorsAndMethods.setBaseClassConstructors(baseclassConstructors);
        constructorsAndMethods.setBaseClassMethods(baseclassMethods);
        return constructorsAndMethods;
    }

    protected boolean runGeneratorWizard(GeneratorModel model, IWorkbenchWindow workbenchPart) {
        GeneratorWizard wizard = new GeneratorWizard(model);
        WizardDialog dialog = new WizardDialog(workbenchPart.getShell(), (IWizard)wizard);
        dialog.create();
        wizard.initPages();
        dialog.open();
        return wizard.isFinished();
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean generateTestSuites(IJavaProject testProject) throws CoreException, JUTWarning {
        if (testProject == null) {
            return false;
        }
        String testProjectPostfix = JUTPreferences.getTestProjectPostfix();
        String testProjectName = testProject.getElementName();
        if (!testProjectName.endsWith(testProjectPostfix)) {
            throw new JUTWarning("Select a test-project!");
        }
        for (ITestSuitesGenerator testSuitesGenerator : Activator.getDefault().getExtensionHandler().getTestSuitesGenerators()) {
            if (testSuitesGenerator.generateTestSuites(testProject)) continue;
            return false;
        }
        return true;
    }

    public boolean switchClass(IWorkbenchWindow activeWorkbenchWindow, IStructuredSelection selection) throws JUTException, JUTWarning, CoreException {
        JUTElements uTMElements = this.detectJUTElements(selection, null);
        if (uTMElements == null) {
            return false;
        }
        return this.switchClass(activeWorkbenchWindow, uTMElements);
    }

    public boolean switchClass(IWorkbenchWindow activeWorkbenchWindow, IFileEditorInput fileEditorInput) throws JUTException, JUTWarning, CoreException {
        JUTElements uTMElements = this.detectJUTElements(null, fileEditorInput);
        if (uTMElements == null) {
            return false;
        }
        return this.switchClass(activeWorkbenchWindow, uTMElements);
    }

    private boolean switchClass(IWorkbenchWindow activeWorkbenchWindow, JUTElements uTMElements) throws JUTException, JUTWarning, JavaModelException {
        ICompilationUnit classToOpen;
        IMethod selectedMethod = uTMElements.getConstructorsAndMethods().getSelectedMethod();
        JUTElements.JUTProjects projects = uTMElements.getProjects();
        JUTElements.JUTClassesAndPackages classesAndPackages = uTMElements.getClassesAndPackages();
        Shell shell = activeWorkbenchWindow.getShell();
        MethodRef mr = null;
        if (projects.isBaseProjectSelected()) {
            classToOpen = classesAndPackages.getTestClass();
            if (selectedMethod != null) {
                mr = new MethodRef(GeneratorUtils.createTestMethodName(selectedMethod.getElementName()), selectedMethod.getSignature());
            }
        } else {
            classToOpen = classesAndPackages.getBaseClass();
            if (selectedMethod != null) {
                mr = GeneratorUtils.getMethodRef(selectedMethod);
            }
        }
        if (classToOpen != null && classToOpen.exists()) {
            EclipseUIUtils.openInEditor(shell, (IFile)classToOpen.getResource());
            if (selectedMethod != null) {
                EclipseUIUtils.selectMethodInEditor(mr);
            }
            return true;
        }
        if (projects.isBaseProjectSelected()) {
            boolean result = MessageDialog.openConfirm((Shell)shell, (String)"Neue Testklasse generieren?", (String)"Es konnte keine bestehende Testklasse gefunden werden. M\ufffd\ufffd\ufffdchten Sie eine neue Testklasse generieren?");
            if (result) {
                this.generateTestclass(activeWorkbenchWindow, uTMElements);
            }
        } else {
            return false;
        }
        return true;
    }

    public void createReport(IWorkbenchWindow workbenchWindow, final ISelection selection) throws JUTException, JUTWarning, CoreException {
        this.setError(false);
        this.setWarning(null);
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    JUTElements jutElements = MainController.this.detectJUTElements(selection);
                    if (jutElements == null) {
                        MainController.this.setWarning(new JUTWarning(Messages.GeneratorUtils_SelectionNotSupported));
                        return;
                    }
                    ReportCreator rc = new ReportCreator();
                    rc.createNecessaryTestclassesReport(jutElements, monitor);
                    monitor.done();
                }
                catch (Exception e) {
                    MainController.this.setError(true, e);
                }
            }
        };
        try {
            workbenchWindow.run(true, true, runnableWithProgress);
        }
        catch (Exception ex) {
            throw new JUTException(ex);
        }
        if (this.isWarning()) {
            throw this.warningException;
        }
        if (this.isError()) {
            throw new JUTException(this.errorException);
        }
    }

    protected void setWarning(JUTWarning jutWarning) {
        this.warningException = jutWarning;
        this.warning = jutWarning != null;
    }

    private boolean isWarning() {
        return this.warning;
    }

    public int countAllTestMethods(IWorkbenchWindow workbenchWindow, final IStructuredSelection selection) throws JUTException {
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    MainController.this.setError(false);
                    JUTElements jutElements = MainController.this.detectJUTElements(selection, null);
                    ReportCreator rc = new ReportCreator();
                    int methodsCounter = rc.countAllTestMethods(jutElements, monitor);
                    MainController.this.setMethodsCounter(methodsCounter);
                    monitor.done();
                }
                catch (Exception e) {
                    MainController.this.setError(true, e);
                }
            }
        };
        try {
            workbenchWindow.run(true, true, runnableWithProgress);
        }
        catch (Exception ex) {
            throw new JUTException(ex);
        }
        if (this.isError()) {
            throw new JUTException(this.errorException);
        }
        return this.methodsCounter;
    }

    protected void setMethodsCounter(int methodsCounter) {
        this.methodsCounter = methodsCounter;
    }
}

