/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tools.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.junit.tools.generator.IMockClassGenerator;
import org.junit.tools.generator.ITestClassGenerator;
import org.junit.tools.generator.ITestDataFactory;
import org.junit.tools.generator.ITestSuitesGenerator;
import org.junit.tools.generator.MockClassGenerator;
import org.junit.tools.generator.TestClassGenerator;
import org.junit.tools.generator.TestSuitesGenerator;

public class ExtensionPointHandler {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private static final String EP_GENERATOR = "org.junit.tools.generator";
    private static final String EP_GENERATOR_TD_FACTORY = "org.junit.tools.generator.factory.testdata";
    private static final String EP_PREFERENCES = "org.junit.tools.preferences";
    private boolean customGeneratorsInitialized = false;
    private Vector<ITestClassGenerator> testClassGenerators = null;
    private Vector<ITestClassGenerator> customTestClassGenerators = null;
    private Vector<ITestSuitesGenerator> testSuitesGenerators = null;
    private Vector<ITestSuitesGenerator> customTestSuitesGenerators = null;
    private Vector<IMockClassGenerator> mockClassGenerators = null;
    private Vector<IMockClassGenerator> customMockClassGenerators = null;
    private boolean testDataFactoriesInitialized = false;
    private List<ITestDataFactory> testDataFactories = null;
    private boolean preferenceInitializerInitialized = false;
    private Vector<AbstractPreferenceInitializer> preferenceInitializers;

    public IMockClassGenerator getMockClassGenerator() {
        this.initCustomGenerators();
        if (this.customMockClassGenerators != null && this.customMockClassGenerators.size() > 0) {
            return this.customMockClassGenerators.firstElement();
        }
        if (this.mockClassGenerators == null) {
            this.mockClassGenerators = new Vector();
            this.mockClassGenerators.add(new MockClassGenerator());
        }
        return this.mockClassGenerators.firstElement();
    }

    public Vector<ITestClassGenerator> getTestClassGenerators() throws CoreException {
        this.initCustomGenerators();
        if (this.customTestClassGenerators != null && this.customTestClassGenerators.size() > 0) {
            return this.customTestClassGenerators;
        }
        if (this.testClassGenerators == null) {
            this.testClassGenerators = new Vector();
            this.testClassGenerators.add(new TestClassGenerator());
        }
        return this.testClassGenerators;
    }

    private void initCustomGenerators() {
        if (!this.customGeneratorsInitialized) {
            this.customGeneratorsInitialized = true;
            this.customTestClassGenerators = new Vector();
            this.customTestSuitesGenerators = new Vector();
            this.customMockClassGenerators = new Vector();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(EP_GENERATOR);
            if (point != null) {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        block14: {
                            Object generator;
                            IConfigurationElement configElement = iConfigurationElementArray[n4];
                            String elementName = configElement.getName();
                            try {
                                generator = configElement.createExecutableExtension("class");
                            }
                            catch (CoreException e) {
                                this.logger.warning("unable to initialize custom generator, element name: " + elementName + " message: " + e.getMessage());
                                break block14;
                            }
                            if (generator != null) {
                                try {
                                    if ("testclass_generator".equals(elementName)) {
                                        this.customTestClassGenerators.add((ITestClassGenerator)generator);
                                    } else if ("testsuites_generator".equals(elementName)) {
                                        this.customTestSuitesGenerators.add((ITestSuitesGenerator)generator);
                                    } else if ("mockclass_generator".equals(elementName)) {
                                        this.customMockClassGenerators.add((IMockClassGenerator)generator);
                                    }
                                }
                                catch (ClassCastException e) {
                                    this.logger.warning("wrong custom generator class " + elementName + " message: " + e.getMessage());
                                }
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
    }

    private Vector<ITestSuitesGenerator> getCustomTestSuitesGenerators() throws CoreException {
        return this.customTestSuitesGenerators;
    }

    public Vector<ITestSuitesGenerator> getTestSuitesGenerators() throws CoreException {
        this.initCustomGenerators();
        Vector<ITestSuitesGenerator> cstmTestSuitesGenerators = this.getCustomTestSuitesGenerators();
        if (cstmTestSuitesGenerators.size() > 0) {
            return cstmTestSuitesGenerators;
        }
        if (this.testSuitesGenerators == null) {
            this.testSuitesGenerators = new Vector();
            this.testSuitesGenerators.add(new TestSuitesGenerator());
        }
        return this.testSuitesGenerators;
    }

    public List<ITestDataFactory> getTestDataFactories() throws CoreException {
        if (!this.testDataFactoriesInitialized && this.testDataFactories == null) {
            this.testDataFactories = new ArrayList<ITestDataFactory>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(EP_GENERATOR_TD_FACTORY);
            if (point != null) {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement configElement = iConfigurationElementArray[n4];
                        try {
                            String elementName = configElement.getName();
                            Object testDataFactory = configElement.createExecutableExtension("class");
                            if (testDataFactory != null && "testdata_factory".equals(elementName)) {
                                this.testDataFactories.add((ITestDataFactory)testDataFactory);
                            }
                        }
                        catch (Exception ex) {
                            this.logger.warning("unable to load class of extension-point org.junit.tools.generator.factory.testdata" + ex.getMessage());
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        return this.testDataFactories;
    }

    public Vector<AbstractPreferenceInitializer> getPreferenceInitializer() {
        if (!this.preferenceInitializerInitialized && this.preferenceInitializers == null) {
            this.preferenceInitializers = new Vector();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(EP_PREFERENCES);
            if (point != null) {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement configElement = iConfigurationElementArray[n4];
                        try {
                            AbstractPreferenceInitializer initializer = (AbstractPreferenceInitializer)configElement.createExecutableExtension("class");
                            if (initializer != null) {
                                this.preferenceInitializers.add(initializer);
                            }
                        }
                        catch (CoreException e) {
                            Logger logger = Logger.getLogger(this.getClass().getName());
                            logger.warning("class for extension-point org.junit.tools.preferences could not be loaded! " + e.getMessage());
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        return this.preferenceInitializers;
    }
}

